<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    
    public function faqList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $faq = Faq::where('id',$id)->get();
        }else{
        $faq = Faq::simplePaginate(10);    
        }
        return response()->json(['faq' => $faq], 200);
    }


    public function storeFaq(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'question' => 'required',
                'category' => 'required',
                'answer' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['status' => 'error', 'message' => $messages->first()]);
        }
        $faq = new Faq();
        $faq->title = $request->question;
        $faq->faq_category = $request->category;
        $faq->description = $request->answer;
        $faq->status = $request->status;
        $faq->save();
        return response()->json(['message' => 'Faq Created Successfully', 'faq' => $faq]);
    }


    public function updateFaq(Request $request)
    {
        $id = $request->id;
        $validator = \Validator::make(
            $request->all(), [
                'question' => 'required',
                'category' => 'required',
                'answer' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['status' => 'error', 'message' => $messages->first()]);
        }
        $faq = Faq::find($id);
        if (!$faq) {
            return response()->json(['error' => 'Faq not found'], 404);
        }
        $faq->title = $request->question;
        $faq->faq_category = $request->category;
        $faq->description = $request->answer;
        $faq->status = $request->status;
        $faq->update();
        return response()->json(['message' => 'Faq Updated Successfully', 'faq' => $faq]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function deleteFaq(Request $request)
    {
        $id = $request->input('id');
        $faq = Faq::find($id);
        if (!$faq) {
            return response()->json([
                    'error' => 'faq not found'
                ], 404);
        }
        $faq->delete();
        
        return response()->json(['message' => 'Faq Deleted Successfully']);
    }
    
    

    public function updateStatus(Request $request)
    {
        $faq = Faq::find($request->id);
        $faq->status = $request->status;
        $faq->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
}
