<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;

class GlobalReachController extends Controller
{
    public function globalReachList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $global_reach = DB::table('global_reach')->where('id',$id)->first();
        if ($global_reach) {
        $global_reach->image = $global_reach->image ? url('/') . '/storage/uploads/global-reach/' . $global_reach->image : null;
            }
        }
        else{
        $global_reach = DB::table('global_reach')->simplePaginate(10);    
        foreach ($global_reach as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/global-reach/'. $list->image : null;
            }
        }
        return response()->json(['global_reach' => $global_reach], 200);
    }
    
    public function storeglobalReach(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required',
                'sub_title' => 'required',
                'description' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $data = [
            'title' => $request->post('title'),
            'sub_title' => $request->post('sub_title'),
            'description' => $request->post('description'),
        ];
        
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'global-reach');
            $data['image'] = $image;
        }
            if(empty($request->image)) {
                $data['image'] = ''; 
            }
            DB::table('global_reach')->insert($data);
            $msg = "Global Reach Created Successfully";
        
        return response()->json(['message' => $msg],200);
    }
    
    public function updateglobalReach(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required',
                'sub_title' => 'required',
                'description' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $data = [
            'title' => $request->post('title'),
            'sub_title' => $request->post('sub_title'),
            'description' => $request->post('description'),
        ];
        
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'global-reach');
            $data['image'] = $image;
        }
            DB::table('global_reach')
                ->where('id', $request->id)
                ->update($data);
            $msg = "Global Reach Updated Successfully";

       return response()->json(['message' => $msg],200);
    }
    
    public function deleteglobalReach(Request $request)
    {   
        $id = $request->input('id');

        $global_reach = DB::table('global_reach')->where('id', $id)->first();
        
        if ($global_reach) {
            delete_file('global-reach', $global_reach->image);
        
            DB::table('global_reach')->where('id', $id)->delete();
        
            $msg = "Global Reach Deleted Successfully";
            return response()->json(['message' => $msg], 200);
        } else {
            $msg = "Global Reach Record Not Found";
            return response()->json(['message' => $msg], 404);
        }
    }
    
}
