<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MenuItem;
use App\Models\Pages;
use Illuminate\Support\Str;
use App\Models\PageSection;
use DB;


class MenuSettingsController extends Controller
{
    
    public function keyOffering(Request $request){
        $menuItems = MenuItem::where('parent_id', '=', 2)->with('children')->orderBy('order')->get();
        foreach ($menuItems as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/manu-section/'. $list->image : null;
            }
        return response()->json(['menuItems' => $menuItems], 200);
    }
    
    public function keyOfferingdetails(Request $request){
        $slug = $request->input('slug');
        
        // $pages = Pages::where('slug',$slug)->first();
        // if ($pages) {
        // $pages->banner_image = $pages->banner_image ? url('/') . '/storage/uploads/page-banner/' . $pages->banner_image : null;
        //     }else {
        //         return response()->json([
        //             'success' => false,
        //             'message' => 'Page not found'
        //         ], 404);
        //     }
        // return response()->json(['pages' => $pages], 200);
        if($slug == 'career'){
            $pageSection['section_1']  = DB::table('settings')->select('key', 'value')->whereIn('key', ['careers_title', 'careers_subtitle'])->get();
            $pageSection['section_2'] = DB::table('career')->simplePaginate(10);
            $result['page'] = $pageSection;
        }else{
        $pageSection = Pages::where('slug', $slug)->first();
        
        $pageSection->banner_image = $pageSection->banner_image ? url('/').'/storage/uploads/page-banner/'.$pageSection->banner_image : null;
        $result['page'] = $pageSection;
        $result['section'] = [];
        
        if ($pageSection) {
            foreach (json_decode($pageSection->sections, true) as $list) {
                $section = PageSection::find($list);
                if ($section) {
                    $section->image = $section->image ? url('/').'/storage/uploads/page-section/'.$section->image : null;
                    $result['section'][] = $section;
                    
                }
            }
            
        }
        if ($pageSection->our_journey == 1) {
            $ourjourney = DB::table('ourjourney')->get();
            foreach ($ourjourney as $journey) {
                $journey->images = $journey->images ? url('/') .'/storage/uploads/page-section/'. $journey->images : null;
            }
            $result['section'][]['ourjourney'] = $ourjourney;
        }
        if ($pageSection->partners == 1) {
            $partners = DB::table('team_members')->where('type','partners')->where('status','1')->get();
            foreach ($partners as $partner) {
                $partner->image = $partner->image ? url('/') .'/storage/uploads/partners/'. $partner->image : null;
            }
            $result['section'][]['partners'] = $partners;
        }
        if ($pageSection->team_members == 1) {
            $team_members = DB::table('team_members')->where('type','team-member')->where('status','1')->get();
            foreach ($team_members as $partner) {
                $partner->image = $partner->image ? url('/') .'/storage/uploads/team-members/'. $partner->image : null;
            }
            $result['section'][]['team_members'] = $team_members;
        }
        
        if ($pageSection->career != null) {
            $career = DB::table('career')->where('id',$pageSection->career)->first();
            
        }
        
        if ($pageSection->faq_categories != null) {
            $faq_categories = DB::table('faqs')
                                ->where('faq_category', $pageSection->faq_categories)
                                ->get();
            
            $result['section'][]['faq'] = $faq_categories;
        }
        }
    
        if ($pageSection) {
            return response()->json([
                'status' => 'success',
                'message' => '',
                'data' => $result,
            ]);
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Menu items not found',
                'data' => []
            ], 404);
        }
    }
    
    public function menuList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $menuItems = MenuItem::whereNull('parent_id')->with('children')->orderBy('order')->where('id',$id)->get();
        }else{
        $menuItems = MenuItem::whereNull('parent_id')->with('children')->orderBy('order')->simplePaginate(10);  
        }
        return response()->json(['menuItems' => $menuItems], 200);
    }
    
    public function storeMenu(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'url' => 'required',
            'parent_id' => 'nullable|exists:menu_items,id'
        ]);
        
    
        $input = $request->all();
    
        $input['slug'] = Str::slug($request->title);
        $manuItem = MenuItem::create($input);
        return response()->json(['message' => 'Menu Item Created Successfully', 'manuItem' => $manuItem]);
    }
    
    public function updateMenu(Request $request)
    {
        $id = $request->id;
        $request->validate([
            'title' => 'required|string|max:255',
            'url' => 'required',
            'parent_id' => 'nullable|exists:menu_items,id'
        ]);
    
        // Get all input data
        $input = $request->all();
    
        // Create a slug from the title
        $input['slug'] = Str::slug($request->title);
        
        $menuItem = MenuItem::findOrFail($id);
        if (!$menuItem) {
            return response()->json(['error' => 'Menu Item not found'], 404);
        }
        $menuItem->update($input);
        return response()->json(['message' => 'Menu Item Update Successfully', 'menuItem' => $menuItem]);
    }
    
    public function deleteMenu(Request $request)
    {   
        $id = $request->input('id');
        $menuItem = MenuItem::find($id);
        if (!$menuItem) {
            return response()->json([
                    'error' => 'Menu Item not found'
                ], 404);
        }
        $menuItem->delete();
        
        return response()->json(['message' => 'Menu Item Deleted Successfully']);
    }
    
}
