<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;

class TestimonialController extends Controller
{
    public function testimonial(Request $request)
    {
        $testimonial = DB::table('testimonial')->where('type','team')->simplePaginate(10);    
            foreach ($testimonial as $list) {
                    $list->image = $list->image ? url('/') .'/storage/uploads/testimonial/'. $list->image : null;
                }
        
        return response()->json(['testimonial' => $testimonial], 200);
    }
    
    public function testimonialList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $testimonial = DB::table('testimonial')->where('id',$id)->first();
        if ($testimonial) {
        $testimonial->image = $testimonial->image ? url('/') . '/storage/uploads/testimonial/' . $testimonial->image : null;
            }
        }
        else{
        $testimonial = DB::table('testimonial')->simplePaginate(10);    
        foreach ($testimonial as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/testimonial/'. $list->image : null;
            }
        }
        return response()->json(['testimonial' => $testimonial], 200);
    }
    
    public function storeTestimonial(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required',
                'description' => 'required',
                'designation' => 'required',
                'type' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $data = [
            'name' => $request->post('name'),
            'designation' => $request->post('designation'),
            'description' => $request->post('description'),
            'type' => $request->post('type'),
            'status' => $request->post('status'),
        ];
            
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'testimonial');
            $data['image'] = $image;
        }
        
            DB::table('testimonial')->insert($data);
            $msg = "Testimonial Created Successfully";
        

        return response()->json(['message' => $msg],200);
    }
    
    public function updateTestimonial(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required',
                'designation' => 'required',
                'description' => 'required',
                'type' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $data = [
            'name' => $request->post('name'),
            'designation' => $request->post('designation'),
            'description' => $request->post('description'),
            'type' => $request->post('type'),
            'status' => $request->post('status'),
        ];
            
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'testimonial');
            $data['image'] = $image;
        }
        
            DB::table('testimonial')
                ->where('id', $request->id)
                ->update($data);
            $msg = "Testimonial Updated Successfully";
        

       return response()->json(['message' => $msg],200);
    }
    
    public function deleteTestimonial(Request $request)
    {   
        $id = $request->input('id');

        $testimonial = DB::table('testimonial')->where('id', $id)->first();
        
        if ($testimonial) {
            delete_file('testimonial', $testimonial->image);
        
            DB::table('testimonial')->where('id', $id)->delete();
        
            $msg = "Testimonial Deleted Successfully";
            return response()->json(['message' => $msg], 200);
        } else {
            $msg = "Testimonial Record Not Found";
            return response()->json(['message' => $msg], 404);
        }
    }
    
}
