<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use App\Models\User;


class UsersController extends Controller
{
    public function resetPassword(Request $request)
    {
        $id = $request->id;

        $validator = \Validator::make($request->all(), [
            'password' => 'required|min:6',
            'confirm_password' => 'required|same:password',
        ]);
        
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }
        
        $user = User::find($id);
        
        if ($user) {
            $user->password = \Hash::make($request->password);
            $user->save();
        
            return response()->json(['message' => 'Password reset successfully']);
        } else {
            return response()->json(['error' => 'User not found'], 404);
        }

    }
    
    public function updateProfile(Request $request)
    {
        $id = $request->id;

        $validationParam = [
            'name' => 'required|string|max:255',
        ];

        $validator = \Validator::make(
            $request->all(), $validationParam
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        
        $user = User::find($id);
        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }

        if(!empty($request->image))
        {
            $profile = upload_file($request->image,'profile',$user->profile);
            $user->profile = $profile;
        }

        $user->name = $request->name;
        $user->phone_no = $request->phone_no;
        $user->update();

        
        return response()->json(['message' => 'Profile updated successfully','profile'=>$user]);
    }
    
    public function updateEmail(Request $request)
    {   
        $id = $request->id;
        
        $validationParam = [
            'email' => 'required|email|unique:users,email,' . $id,
            'password' => 'required|string|max:255',
        ];

        $validator = \Validator::make(
            $request->all(), $validationParam
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return response()->json(['error' => $messages->first()]);
        }
        $user = User::find($id);
        
        if(Hash::check($request->password, $user->password))
        {
            $user->email = $request->email;
            $user->update();
        }
        else
        {
             return response()->json(['message' => 'Password does not match']);
        }

        return response()->json(['message' => 'Email updated successfully']);
    }
    
    public function changePassword(Request $request)
    {
            $id = $request->id;
            $validator = \Validator::make(
                $request->all(), [
                    'current_password' => 'required',
                    'password' => 'required|min:6',
                    'confirm_password' => 'required|same:password',
                ]
            );
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json(['error' => $messages->first()]);
            }
            $user = User::find($id);
            if(Hash::check($request->current_password, $user->password))
            {
                $user->password = Hash::make($request->password);
                $user->update();
                 return response()->json(['message' => 'Password changed successfully']);
            }
            else
            {
                return response()->json(['message' => 'Current password does not match']);
            }
        
    }
    
}
