<?php

namespace App\Http\Controllers\Api\v2;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HeroSection;


class HeroController extends Controller
{
    public function heroSectionList(Request $request)
    {
        $id = $request->input('id');
        if($id){
        $heroSections = HeroSection::where('id',$id)->orderBy('order','ASC')->first();
        if ($heroSections) {
        $heroSections->image = $heroSections->image ? url('/') . '/storage/uploads/hero-section/' . $heroSections->image : null;
            }
        }else{
        if($request->input('perpage') > 0){
        $heroSections = HeroSection::orderBy('order','ASC')->simplePaginate($request->input('perpage'));
        }else{
        $heroSections = HeroSection::orderBy('order','ASC')->get();
        }
        foreach ($heroSections as $list) {
                $list->image = $list->image ? url('/') .'/storage/uploads/hero-section/'. $list->image : null;
            }
        }
        return response()->json(['heroSections' => $heroSections], 200);
    }
    
    public function storeHeroSection(Request $request)
    {
        $heroSection = new HeroSection();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'hero-section');
            $heroSection->image = $image;
        }

        $order = HeroSection::count();

        $heroSection->order = $order + 1;
        $heroSection->title = $request->title;
        $heroSection->description = $request->description;
        $heroSection->status = $request->status == 'on' ? 1 : 0;
        $heroSection->save();

        return response()->json(['message' => 'Hero Created Successfully', 'heroSection' => $heroSection]);
    }
    
    public function updateHeroSection(Request $request)
    {
        $id = $request->input('id');
        $heroSection = HeroSection::find($id);
        if (!$heroSection) {
            return response()->json(['error' => 'Hero Section not found'], 404);
        }
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'hero-section',$heroSection->image);
            $heroSection->image = $image;
        }
        $heroSection->title = $request->title;
        $heroSection->description = $request->description;
        $heroSection->status = $request->status == 'on' ? 1 : 0;
        $heroSection->update();

        return response()->json(['message' => 'Hero Update Successfully', 'heroSection' => $heroSection]);
    }
    
    public function deleteHeroSection(Request $request)
    {
        $id = $request->input('id');
        $heroSection = HeroSection::find($id);
        if (!$heroSection) {
            return response()->json([
                    'error' => 'Hero Section not found'
                ], 404);
        }
        delete_file('hero-section',$heroSection->image);
        $heroSection->delete();
        return response()->json(['message' => 'Hero Deleted Successfully']);
    }
    
}
