<?php

namespace App\Http\Controllers;

use App\Models\HeroSection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use DB;

class ApprovedAuditorsController extends Controller
{
    
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_blog'), 404);
        $approved = DB::table('approved_auditors')
    ->get();
        return view('backend.approved-auditors.index',compact('approved'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_blog'), 404);
        $pages = DB::table('pages')->get();
        return view('backend.approved-auditors.create',compact('pages'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // abort_if(auth()->user()->cannot('create_blog'), 404);
         $validator = \Validator::make(
            $request->all(), 
            [
                'image' => 'required|image|mimes:jpeg,png,jpg,webp|max:2048', // Image must be valid and less than 2MB
                'link' => 'required|url', // URL must be valid
            ],
            [
                'image.required' => 'The image field is required.',
                'image.image' => 'The file must be an image.',
                'image.mimes' => 'The image must be a file of type: jpeg, png, jpg, gif.',
                'image.max' => 'The image may not be greater than 2MB.',
                'link.required' => 'The link field is required.',
                'link.url' => 'The link must be a valid URL.',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }
        $approvedData = [];

        // Handle image upload if available
        if (!empty($request->image)) {
            $image = upload_file($request->image, 'approved-auditors');
            $approvedData['image'] = $image; // Assign the uploaded image to the array
        }
        
        // Set other fields from the request
       
        $approvedData['link'] = $request->link;
        
        // Insert the data into the approved_auditors tablev
        DB::table('approved_auditors')->insert($approvedData);

        return redirect()->route('approved-auditors.index')->with('success','approved Profile Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort_if(auth()->user()->cannot('edit_blog'), 404);
        $approved = DB::table('approved_auditors')->where('id', $id)->first();
        $pages = DB::table('pages')->get();
        return view('backend.approved-auditors.edit',compact('approved','pages'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
       $validator = \Validator::make(
            $request->all(), 
            [
                'link' => 'required|url', // URL must be valid
            ],
            [
                'image.required' => 'The image field is required.',
                'image.image' => 'The file must be an image.',
                'image.mimes' => 'The image must be a file of type: jpeg, png, jpg, gif.',
                'image.max' => 'The image may not be greater than 2MB.',
                'link.required' => 'The link field is required.',
                'link.url' => 'The link must be a valid URL.',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }

       $approvedData = [];

        if (!empty($request->image)) {
            $image = upload_file($request->image, 'approved-auditors', $approved->image);
            $approvedData['image'] = $image; 
        }
        
       
        $approvedData['link'] = $request->link;
        
        DB::table('approved_auditors')->where('id', $id)->update($approvedData);

        return redirect()->route('approved-auditors.index')->with('success','approved Profile Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
   public function destroy(string $id)
{
    // Fetch the approved profile record by ID
    $approved = DB::table('approved_auditors')->where('id', $id)->first();

    // Check if the approved profile exists
    if ($approved) {
        delete_file('approved-auditors', $approved->image);

        DB::table('approved_auditors')->where('id', $id)->delete();

        return redirect()->back()->with('success', 'approved Profile Deleted Successfully');
    }

    return redirect()->back()->with('error', 'approved Profile Not Found');
}
// remove image

public function removeImage(Request $request)
{
    try {
    // Validate the request to ensure 'id' is provided
    $request->validate([
        'id' => 'required',
    ]);

    // Fetch the approved profile record by ID
    $approved = DB::table('approved_auditors')->where('id', $request->id)->first();

    // Check if the entry exists and has an associated image
    if ($approved && $approved->image) {
        $imagePath = 'uploads/approved-auditors/' . $approved->image;

        // Delete the image file
        delete_file('approved-auditors', $approved->image);

        // Remove the image path from the database by updating the record
        DB::table('approved_auditors')
            ->where('id', $request->id)
            ->update(['image' => null]);  // Set image to null in the database

        return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
    } else {
        return response()->json(['success' => false, 'message' => 'approved profile or image not found.']);
    }
} catch (\Exception $e) {
    // Log any exceptions that occur
    Log::error('Error removing image: ' . $e->getMessage());
    return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
}

}


    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_hero_section'), 404);
        $approved = HeroSection::find($request->id);
        $approved->status = $request->status;
        $approved->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }

    public function sort(Request $request)
    {
        foreach($request->order as $key => $heroId)
        {
            HeroSection::where('id',$heroId)->update(['order' => $key + 1]);
        }

        return true;
    }
}
