<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Settings;


class CareerController extends Controller
{
    public function ourCareerList(Request $request)
    {
        if($request->isMethod('POST'))
        {
            
            foreach($request->except(['_token']) as $key => $value)
            {
                if ($key == 'careers_image') {
                    $careers_image = 'careers_image.png';
                    $request->careers_image->move(public_path('assets/media/img'), $careers_image);
                    $value = 'careers_image.png';
                }
                $save = ['key' => $key, 'value' => $value];
                Settings::updateOrCreate(
                    [
                        'key' => $key
                    ], $save
                );
            }

            return redirect()->back()->with('success', __('Career Settings updated'));
        }
        $ourjourney = DB::table('career')->get();
        $settings = get_all_setting();
        return view('backend.career.careerlist',compact('ourjourney','settings'));
    }
    
    public function manage_career(Request $request, $id = '')
    {
        if ($id > 0) {
            $route = DB::table('career')->where('id', $id)->first();
            $result['profile'] = $route->profile;
            $result['qualification'] = $route->qualification;
            $result['candidate'] = $route->candidate;
            $result['location'] = $route->location;
            $result['profile_description'] = $route->profile_description;
            $result['no_of_positions'] = $route->no_of_positions;
            $result['id'] = $route->id;
        } else {
            $result['profile'] = "";
            $result['qualification'] = "";
            $result['candidate'] = "";
            $result['location'] = "";
            $result['profile_description'] = "";
            $result['no_of_positions'] = "";
            $result['id'] = "";
        }
        return view('backend.career.index', $result);
    }

    public function storecareer(Request $request)
    {   
        $validator = \Validator::make(
            $request->all(), [
                'profile' => 'required',
                'qualification' => 'required',
                'candidate' => 'required',
                'location' => 'required',
                'profile_description' => 'required',
                'no_of_positions' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }
        
        $data = [
            'profile' => $request->post('profile'),
            'qualification' => $request->post('qualification'),
            'profile_description' => $request->post('profile_description'),
            'candidate' => $request->post('candidate'),
            'location' => $request->post('location'),
            'no_of_positions' => $request->post('no_of_positions'),
        ];
        if ($request->id > 0) {
            DB::table('career')
                ->where('id', $request->id)
                ->update($data);
            $msg = "Career Updated Successfully";
        } else {
            DB::table('career')->insert($data);
            $msg = "Career Created Successfully";
        }

        return redirect()->route('career.list')->with('success', $msg);
    }


    public function delete($id)
    {
        DB::table('career')->where('id', $id)->delete();

        return redirect()->route('career.list')->with('success', 'Career Delete Successfully'); 
    }
    
}
