<?php

namespace App\Http\Controllers;

use App\Models\HeroSection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use DB;

class CompanyProfileController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_blog'), 404);
        $company = DB::table('company_profile')->first();
        return view('backend.company-profile.index',compact('company'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.company-profile.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = \Validator::make(
            $request->all(),
            [
                'title' => 'required|string|max:255', // Must be a string with a max length of 255 characters
                'description' => 'required|string', // Must be a string
                'count' => 'required|integer|min:1', // Must be a positive integer
                'btnlink' => 'required|url', // Must be a valid URL
            ],
            [
                'title.required' => 'The title field is required.',
                'title.string' => 'The title must be a string.',
                'title.max' => 'The title may not be greater than 255 characters.',
                'description.required' => 'The description field is required.',
                'description.string' => 'The description must be a string.',
                'count.required' => 'The count field is required.',
                'count.integer' => 'The count must be an integer.',
                'count.min' => 'The count must be at least 1.',
                'btnlink.required' => 'The button link field is required.',
                'btnlink.url' => 'The button link must be a valid URL.',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }
        $companyData = [];

        // Handle image upload if available
        if (!empty($request->image)) {
            $image = upload_file($request->image, 'company-profile');
            $companyData['image'] = $image; // Assign the uploaded image to the array
        }
        
        // Set other fields from the request
        $companyData['title'] = $request->title;
        $companyData['description'] = $request->description;
        $companyData['count'] = $request->count;
        $companyData['btnlink'] = $request->btnlink;
        
        // Insert the data into the company_profile table
        DB::table('company_profile')->insert($companyData);

        return redirect()->route('company-profile.index')->with('success','Company Profile Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort_if(auth()->user()->cannot('edit_blog'), 404);
        $company = DB::table('company_profile')->where('id', $id)->first();
        $pages = DB::table('pages')->get();
        return view('backend.company-profile.edit',compact('company','pages'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
      $validator = \Validator::make(
            $request->all(),
            [
                'title' => 'required|string|max:255', // Must be a string with a max length of 255 characters
                'description' => 'required|string', // Must be a string
                'count' => 'required|integer|min:1', // Must be a positive integer
                'btnlink' => 'required|url', // Must be a valid URL
            ],
            [
                'title.required' => 'The title field is required.',
                'title.string' => 'The title must be a string.',
                'title.max' => 'The title may not be greater than 255 characters.',
                'description.required' => 'The description field is required.',
                'description.string' => 'The description must be a string.',
                'count.required' => 'The count field is required.',
                'count.integer' => 'The count must be an integer.',
                'count.min' => 'The count must be at least 1.',
                'btnlink.required' => 'The button link field is required.',
                'btnlink.url' => 'The button link must be a valid URL.',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }
       $companyData = [];

        if (!empty($request->image)) {
            $image = upload_file($request->image, 'company-profile');
            $companyData['image'] = $image; 
        }
        
         if (!empty($request->mobile_image)) {
            $mobile_image = upload_file($request->mobile_image, 'company-profile');
            $companyData['mobile_image'] = $mobile_image; 
        }
        
        $companyData['title'] = $request->title;
        $companyData['description'] = $request->description;
        $companyData['sub_title'] = $request->sub_title;
        $companyData['sub_description'] = $request->sub_description;
        $companyData['count'] = $request->count;
        $companyData['btnlink'] = $request->btnlink;
        
        DB::table('company_profile')->where('id', $id)->update($companyData);

        return redirect()->route('company-profile.index')->with('success','Company Profile Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
   public function destroy(string $id)
{
    // Fetch the company profile record by ID
    $company = DB::table('company_profile')->where('id', $id)->first();

    // Check if the company profile exists
    if ($company) {
        delete_file('company-profile', $company->image);

        DB::table('company_profile')->where('id', $id)->delete();

        return redirect()->back()->with('success', 'Company Profile Deleted Successfully');
    }

    return redirect()->back()->with('error', 'Company Profile Not Found');
}
// remove image

public function removeImage(Request $request)
{
    try {
    // Validate the request to ensure 'id' is provided
    $request->validate([
        'id' => 'required',
    ]);

    // Fetch the company profile record by ID
    $company = DB::table('company_profile')->where('id', $request->id)->first();

    // Check if the entry exists and has an associated image
    if ($company && $company->image) {
        $imagePath = 'uploads/company-profile/' . $company->image;

        // Delete the image file
        delete_file('company-profile', $company->image);

        // Remove the image path from the database by updating the record
        DB::table('company_profile')
            ->where('id', $request->id)
            ->update(['image' => null]);  // Set image to null in the database

        return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
    } else {
        return response()->json(['success' => false, 'message' => 'Company profile or image not found.']);
    }
} catch (\Exception $e) {
    // Log any exceptions that occur
    Log::error('Error removing image: ' . $e->getMessage());
    return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
}

}


    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_hero_section'), 404);
        $company = HeroSection::find($request->id);
        $company->status = $request->status;
        $company->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }

    public function sort(Request $request)
    {
        foreach($request->order as $key => $heroId)
        {
            HeroSection::where('id',$heroId)->update(['order' => $key + 1]);
        }

        return true;
    }
}
