<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Settings;
use App\Models\Timezones;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class GlobalReachController extends Controller
{
    public function index(Request $request)
    {
        if($request->isMethod('POST'))
        {
            foreach($request->only(['the_global_title','the_global_subtitle']) as $key => $value)
            {
                $save = ['key' => $key, 'value' => $value];
                Settings::updateOrCreate(
                    [
                        'key' => $key
                    ], $save
                );
            }

            return redirect()->back()->with('success', __('Global Reach updated'));
        }
        
        $global_reach = DB::table('global_reach')->get();
        $settings = get_all_setting();
        return view('backend.global-reach.index',compact('global_reach','settings'));
    }
    
    public function manage_global_reach(Request $request, $id = '')
    {
        if ($id > 0) {
            $route = DB::table('global_reach')->where('id', $id)->first();
            $result['title'] = $route->title;
            $result['sub_title'] = $route->sub_title;
            $result['description'] = $route->description;
            $result['image'] = $route->image;
            $result['section'] = $route->section;
            $result['page_url'] = $route->page_url;
            $result['id'] = $route->id;
        } else {
            $result['title'] = "";
            $result['sub_title'] = "";
            $result['description'] = "";
            $result['page_url'] = "";
            $result['section'] = "";
            $result['image'] = "";
            $result['id'] = "";
        }
        return view('backend.global-reach.create', $result);
    }
    
    public function store(Request $request)
    {
        $validator = \Validator::make(
            $request->all(), [
                'title' => 'required',
                'sub_title' => 'required',
                'description' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }
        $slug = Str::slug($request->post('title'));
        
        $data = [
            'title' => $request->post('title'),
            'sub_title' => $request->post('sub_title'),
            'description' => $request->post('description'),
            'section' => $request->post('section'),
            'page_url' => $request->post('page_url'),
            'slug' => $slug,
        ];
        
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'global-reach');
            $data['image'] = $image;
        }
        
        if ($request->id > 0) {
            // Update the existing entry
            DB::table('global_reach')
                ->where('id', $request->id)
                ->update($data);
            $msg = "Global Reach Updated Successfully";
        } else {
            // Insert new entry
            if(empty($request->image)) {
                $data['image'] = ''; 
            }
            DB::table('global_reach')->insert($data);
            $msg = "Global Reach Created Successfully";
        }

        return redirect()->back()->with('success', $msg);
    }
    
    
    //image delete
    
    public function removeImage(Request $request)
{
    try {
        // Validate the request to ensure 'id' is provided
        $request->validate([
            'id' => 'required',
        ]);

        // Find the HeroSection entry by ID
        $global_reach = DB::table('global_reach')->where('id', $request->id)->first();

        // Check if the entry exists and has an associated image
        if ($global_reach && $global_reach->image) {
            $imagePath = 'uploads/global-reach/' . $global_reach->image;

            delete_file('global-reach', $global_reach->image);

            // Remove the image path from the database
            DB::table('global_reach')
                ->where('id', $request->id)
                ->update(['image' => null]);

            return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Hero section or image not found.']);
        }
    } catch (\Exception $e) {
        // Log any exceptions that occur
        Log::error('Error removing image: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
    }
}

    
    
    
    public function delete_global($id)
    {
        // Retrieve the record first
        $global_reach = DB::table('global_reach')->where('id', $id)->first();
        
        // Check if the record exists
        if ($global_reach) {
            // Delete the file
            delete_file('global-reach', $global_reach->image);
            
            // Delete the record
            DB::table('global_reach')->where('id', $id)->delete();
            
            return redirect()->back()->with('success', 'Global Reach Deleted Successfully');
        } else {
            return redirect()->back()->with('error', 'Record not found');
        }
    }

}
