<?php

namespace App\Http\Controllers;

use App\Models\ContactUs;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\URL;
use App\Models\Blog;
use App\Models\Pages;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function dashboard()
    {
        return view('backend.dashboard');
    }

    public function enquires()
    {
        $enquires = ContactUs::get();
        return view('backend.enquires',compact('enquires'));
    }
    
    public function sitemap()
    {
        return view('backend.sitemap.index');
    }

    public function sitemapGenerate(Request $request)
    {
        $baseUrl = config('app.url');

        $staticUrls = [
            '/',
            '/about-us',
            '/contact',
            '/services',
            '/blogs',
            '/career',
            '/zoho-crm-consulting',
            '/privacy-policy',
        ];

        $blogUrls = [];
        if (class_exists(Blog::class)) {
            $blogUrls = Blog::pluck('slug')
                ->map(fn($slug) => "/blog/details/{$slug}")
                ->toArray();
        }

        $serviceUrls = [];
        if (class_exists(Pages::class)) {
            $serviceUrls = Pages::pluck('slug')
                ->map(fn($slug) => "/{$slug}")
                ->toArray();
        }
        
        $serviceBlockUrls = [];
        
        $globalReach = DB::table('global_reach')->pluck('slug');
        
        if ($globalReach->isNotEmpty()) {
            $serviceBlockUrls = $globalReach->map(fn($slug) => "/services/{$slug}")->toArray();
        }


        $allUrls = array_merge($staticUrls, $blogUrls, $serviceUrls, $serviceBlockUrls);

        $sitemap = '<?xml version="1.0" encoding="UTF-8"?>';
        $sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

        foreach ($allUrls as $url) {
            $sitemap .= '<url>';
            $sitemap .= '<loc>' . $baseUrl . $url . '</loc>';
            $sitemap .= '<lastmod>' . now()->toAtomString() . '</lastmod>';
            $sitemap .= '<changefreq>weekly</changefreq>';
            $sitemap .= '<priority>0.8</priority>';
            $sitemap .= '</url>';
        }

        $sitemap .= '</urlset>';

        $path = base_path('../sitemap.xml');
        File::put($path, $sitemap);

        return redirect()->back()->with(
            'success',
            '✅ Sitemap generated successfully! <a href="' . $baseUrl . '/sitemap.xml" target="_blank">View Sitemap</a>'
        );
    }
    public function uploadRobots(Request $request)
    {
        $request->validate([
            'robots_file' => 'required|mimes:txt|max:2048', // only .txt files, max 2MB
        ]);
    
        $file = $request->file('robots_file');
        $destination = base_path('../robots.txt');
    
        // ✅ Delete old file if exists
        if (File::exists($destination)) {
            File::delete($destination);
        }
    
        $file->move(base_path('..'), 'robots.txt');
    
        return back()->with('success', 'robots.txt uploaded successfully!');
    }
}
