<?php

namespace App\Http\Controllers;

use App\Models\Lead;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\LeadAdminCreated;
use App\Mail\LeadCustomerCreated;



class LeadController extends Controller
{
    // GET /leads
    public function index()
    {
        $leads = Lead::all();
        return response()->json(['leads' => $leads]);
    }

    // POST /leads
    public function store(Request $request)
    {
      
        $validatedData = $request->validate([
            'company_name' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:leads,email',
            'phone' => 'required|string|max:255', 
            'country' => 'nullable|string|max:255', 
            'service' => 'required|string|max:255',
        ]);


        $lead = Lead::create($validatedData);

        //Send email to customer
        Mail::to($lead->email)->send(new LeadCustomerCreated($lead));

        // Send email to admin
        Mail::to('xeylous@gmail.com')->send(new LeadAdminCreated($lead));

        return response()->json(['message' => 'Lead created successfully', 'lead' => $lead], 201);
    }
}
