<?php

namespace App\Http\Controllers;

use App\Models\Menu;
use Illuminate\Http\Request;
use DB;
use App\Models\GetInTouch;
use Mail;
use App\Mail\LeadCustomerCreated;
use App\Mail\LeadAdminCreated;
use Illuminate\Support\Facades\Log;

class MenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_menu'), 404);
        $menus = Menu::all();
        return view('backend.menus.index',compact('menus'));
    }
    
    public function get_in_touch()
    {
        // abort_if(auth()->user()->cannot('manage_menu'), 404);
        // $leads = Lead::all();
        $leads = GetInTouch::all();
         
        return view('backend.get-in-touch.list',compact('leads'));
    }


public function resume()
    {
        abort_if(auth()->user()->cannot('manage_menu'), 404);
        $resumetouch=DB::table('resume')->get();
         
        return view('backend.resume.list',compact('resumetouch'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.menus.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $submenuPostArr = [];
        $submenus = $request->submenu;
        foreach($submenus as $submenuKey => $submenu)
        {
            if(isset($request->submenu_2[$submenuKey]))
            {
                $submenu2Arr = $request->submenu_2[$submenuKey];
                foreach ($submenu2Arr as $submenu2Key => $submenu2)
                {
                    if(isset($request->submenu_3[$submenuKey][$submenu2Key]))
                    {
                        $submenu3Arr = $request->submenu_3[$submenuKey][$submenu2Key];
                        $submenuPostArr[$submenuKey][$submenu][$submenu2[0]] = $submenu3Arr;
                    }
                    else
                    {
                        $submenuPostArr[$submenuKey][$submenu2[0]] = [];
                    }
                }
            }
            else
            {
                $submenuPostArr[$submenuKey][$submenu] = [];
            }
        }

        $check_slug = str_slug($request->name, '-');
        if (Menu::whereSlug($check_slug)->exists())
        {
            $slug = $this->incrementSlug($check_slug);
        }
        else
        {
            $slug = $check_slug;
        }


        $menu = new Menu();
        $menu->name = $request->name;
        $menu->slug = $slug;
        $menu->data = json_encode($submenuPostArr);
        $menu->save();

        return redirect()->route('menu.index')->with('success', 'Menu created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Menu $menu)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Menu $menu)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Menu $menu)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Menu $menu)
    {
        //
    }
    public function storeLead(Request $request){
        $validatedData = $request->validate([
            'company_name' => 'required|string|max:255',
            'full_name' => 'required|string|max:255',
            'email' => 'required|email',
            'mobile' => 'required|numeric',
            'country' => 'required|string|max:255', 
            'enquiry_type' => 'required|string|max:255',
        ]);
    
        try {
            $lead = GetInTouch::create($validatedData);
    
            // Send email to customer
            Mail::to($lead->email)->send(new LeadCustomerCreated($lead, $lead->name, $lead->company_name));
        
            // // Send email to admin
            Mail::to('xeylous@gmail.com')->send(new LeadAdminCreated($lead));
        
            return response()->json(['success' => true,'message' => 'Lead created successfully', 'lead' => $lead], 201);
        } catch (\Exception $th) {
            Log::critical($th);
            return response()->json(['success' => false,'message' => 'Something went wrong.']);
        }

    }
}
