<?php

namespace App\Http\Controllers;

use App\Models\Offices;
use Illuminate\Http\Request;

class OfficesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_office'), 404);
        $offices = Offices::get();
        return view('backend.office.index',compact('offices'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_office'), 404);
        return view('backend.office.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_office'), 404);

        $validator = \Validator::make(
            $request->all(), [
                'country' => 'required',
                'company_name' => 'required',
                'address' => 'required',
                'web_url' => 'required',
                'status' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }

        $office = new Offices();
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'office');
            $office->image = $image;
        }
        $office->country = $request->country;
        $office->company_name = $request->company_name;
        $office->trade_id = $request->trade_id;
        $office->address = $request->address;
        $office->phone = $request->phone;
        $office->mobile = $request->mobile;
        $office->whatsapp = $request->whatsapp;
        $office->email = $request->email;
        $office->web_url = $request->web_url;
        $office->status = $request->status == 'on' ? 1 : 0;
        $office->save();

        return redirect()->route('office.index')->with('success','Office Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Offices $offices)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Offices $office)
    {
        abort_if(auth()->user()->cannot('edit_office'), 404);
        return view('backend.office.edit',compact('office'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Offices $office)
    {
        abort_if(auth()->user()->cannot('edit_office'), 404);

        $validator = \Validator::make(
            $request->all(), [
                'country' => 'required',
                'company_name' => 'required',
                'address' => 'required',
                'web_url' => 'required',
                'status' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'office');
            $office->image = $image;
        }
        $office->country = $request->country;
        $office->company_name = $request->company_name;
        $office->trade_id = $request->trade_id;
        $office->address = $request->address;
        $office->phone = $request->phone;
        $office->mobile = $request->mobile;
        $office->whatsapp = $request->whatsapp;
        $office->email = $request->email;
        $office->web_url = $request->web_url;
        $office->status = $request->status == 'on' ? 1 : 0;
        $office->update();

        return redirect()->route('office.index')->with('success','Office Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Offices $office)
    {
        $office->delete();
        return redirect()->back()->with('success','Office Deleted Successfully');
    }

    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_office'), 404);
        $office = Offices::find($request->id);
        $office->status = $request->status;
        $office->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }
}
