<?php

namespace App\Http\Controllers;

use App\Models\PageSection;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Log;

class PageSectionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->user()->cannot('manage_page_section'), 404);
        $pageSections = PageSection::all();
        return view('backend.page-section.index',compact('pageSections'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->user()->cannot('create_page_section'), 404);
        return view('backend.page-section.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->user()->cannot('create_page_section'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }

        $check_slug = str_slug($request->name, '-');
        if (PageSection::whereSlug($check_slug)->exists())
        {
            $slug = $this->incrementSlug($check_slug);
        }
        else
        {
            $slug = $check_slug;
        }

        $pageSection = new PageSection();
        
        if(!empty($request->image))
        {
            $image = upload_file($request->image,'page-section');
            $pageSection->image = $image;
        }
        
        if(!empty($request->bg_image))
        {
            $bg_image = upload_file($request->bg_image,'page-section');
            $pageSection->bg_image = $bg_image;
        }
        
        $pageSection->name = $request->name;
        $pageSection->image_position = $request->image_position;
        $pageSection->slug = $slug;
        $pageSection->description = $request->description;
        $pageSection->status = $request->status == 'on' ? 1 : 0;
        $pageSection->save();
        

        return redirect()->route('page-section.index')->with('success','Page Section Created Successfully');
    }
    



    public function removesectionImage(Request $request)
    {
        try {
            // Validate the request to ensure 'id' is provided
            $request->validate([
                'id' => 'required',
            ]);
    
            // Find the TeamMember entry by ID using the TeamMembers model
            $pagesection = PageSection::find($request->id);
    
            // Check if the entry exists and has an associated image
            if ($pagesection && $pagesection->image) {
                $imagePath = 'uploads/page-section/' . $pagesection->image;
    
                // Use a helper function to delete the image file
                delete_file('page-section', $pagesection->image);
    
                // Remove the image path from the database
                $pagesection->image = null;
                $pagesection->save();
    
                return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
            } else {
                return response()->json(['success' => false, 'message' => 'Team member or image not found.']);
            }
        } catch (\Exception $e) {
            // Log any exceptions that occur
            Log::error('Error removing image: ' . $e->getMessage());
            return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
        }
    }
    
    public function removesectionbgImage(Request $request)
    {
        try {
            // Validate the request to ensure 'id' is provided
            $request->validate([
                'id' => 'required',
            ]);
    
            // Find the TeamMember entry by ID using the TeamMembers model
            $pagesection = PageSection::find($request->id);
    
            // Check if the entry exists and has an associated image
            if ($pagesection && $pagesection->bg_image) {
                $imagePath = 'uploads/page-section/' . $pagesection->bg_image;
    
                // Use a helper function to delete the image file
                delete_file('page-section', $pagesection->bg_image);
    
                // Remove the image path from the database
                $pagesection->bg_image = null;
                $pagesection->save();
    
                return response()->json(['success' => true, 'message' => 'Background Image removed successfully.']);
            } else {
                return response()->json(['success' => false, 'message' => 'Background image not found.']);
            }
        } catch (\Exception $e) {
            // Log any exceptions that occur
            Log::error('Error removing image: ' . $e->getMessage());
            return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
        }
    }

    
    
    
    public function ourjourneyList()
    {
        $ourjourney = DB::table('ourjourney')->get();
        return view('backend.page-section.list_ourjourney',compact('ourjourney'));
    }
    
    public function manage_ourjourney(Request $request, $id = '')
    {
        if ($id > 0) {
            $route = DB::table('ourjourney')->where('id', $id)->first();
            $result['year'] = $route->year;
            $result['descriptions'] = $route->descriptions;
            $result['images'] = $route->images;
            $result['id'] = $route->id;
        } else {
            $result['year'] = "";
            $result['descriptions'] = "";
            $result['images'] = "";
            $result['id'] = "";
        }
        return view('backend.page-section.manage_ourjourney', $result);
    }
    
    public function storeourjourney(Request $request)
    {
        abort_if(auth()->user()->cannot('create_page_section'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'year' => 'required',
                'description' => 'required',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }
        
        $data = [
            'year' => $request->post('year'),
            'descriptions' => $request->post('description'),
        ];
        
        if(!empty($request->image)) {
            $image = upload_file($request->image, 'page-section');
            $data['images'] = $image;
        }
        
        if ($request->id > 0) {
            // Update the existing entry
            DB::table('ourjourney')
                ->where('id', $request->id)
                ->update($data);
            $msg = "Our Journey Updated Successfully";
        } else {
            // Insert new entry
            if(empty($request->image)) {
                $data['images'] = ''; // Ensure images field is set even if no image is uploaded
            }
            DB::table('ourjourney')->insert($data);
            $msg = "Our Journey Created Successfully";
        }

        return redirect()->back()->with('success', $msg);
    }

    /**
     * Display the specified resource.
     */
    public function show(PageSection $pageSection)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PageSection $pageSection)
    {
        abort_if(auth()->user()->cannot('edit_page_section'), 404);
        
        return view('backend.page-section.edit',compact('pageSection'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PageSection $pageSection)
    {
        abort_if(auth()->user()->cannot('edit_page_section'), 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|string|max:255',
            ]
        );

        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error',$messages->first());
        }

        $check_slug = str_slug($request->name, '-');
        if ($pageSection->getOriginal('slug') != $check_slug)
        {
            if (PageSection::whereSlug($check_slug)->exists())
            {
                $slug = $this->incrementSlug($check_slug);
            }
            else
            {
                $slug = $check_slug;
            }
        }
        else
        {
            $slug = $check_slug;
        }

        if(!empty($request->image))
        {
            $image = upload_file($request->image,'page-section',$pageSection->image);
            $pageSection->image = $image;
        }
        
        if(!empty($request->bg_image))
        {
            $bg_image = upload_file($request->bg_image,'page-section',$pageSection->bg_image);
            $pageSection->bg_image = $bg_image;
        }
        
        $pageSection->name = $request->name;
        $pageSection->image_position = $request->image_position;
        $pageSection->slug = $slug;
        $pageSection->description = $request->description;
        $pageSection->status = $request->status == 'on' ? 1 : 0;
        $pageSection->update();
        
        return redirect()->route('page-section.index')->with('success','Page Section Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PageSection $pageSection)
    {
        abort_if(auth()->user()->cannot('delete_page_section'), 404);
        delete_file('page-section',$pageSection->image);
        $pageSection->delete();
        return redirect()->back()->with('success','Page Section Deleted Successfully');
    }
    
    
     public function removeImage(Request $request)
{
    try {
        // Validate the request to ensure 'id' is provided
        $request->validate([
            'id' => 'required',
        ]);

        // Find the TeamMember entry by ID using the TeamMembers model
         $pageSection = DB::table('ourjourney')->where('id', $request->id)->first();

        // Check if the entry exists and has an associated image
        if ($pageSection && $pageSection->images) {
            $imagePath = 'uploads/page-section/' . $pageSection->images;

            // Use a helper function to delete the image file
            delete_file('page-section',$pageSection->images);

            // Remove the image path from the database
            DB::table('ourjourney')
                ->where('id', $request->id)
                ->update(['images' => null]);

            return response()->json(['success' => true, 'message' => 'Image removed successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Team member or image not found.']);
        }
    } catch (\Exception $e) {
        // Log any exceptions that occur
        Log::error('Error removing image: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'An error occurred while removing the image.']);
    }
}

    public function updateStatus(Request $request)
    {
        abort_if(auth()->user()->cannot('edit_page_section'), 404);
        $pageSection = PageSection::find($request->id);
        $pageSection->status = $request->status;
        $pageSection->update();
        return response()->json([
            'status' => 'success',
            'message' => __('Status updated')
        ]);
    }

    public function incrementSlug($slug)
    {
        for($i = 1; $i <= 100; $i++)
        {
            $new_slug = $slug . '-' . $i;
            if(!PageSection::whereSlug($new_slug)->exists())
            {
                return $new_slug;
            }
        }
    }
    
    public function deleteOurjourney($id)
    {   
        DB::table('ourjourney')->where('id', $id)->delete();
        
        return redirect()->back()->with('success','Our Journey Deleted Successfully');
    }
    
    public function editOurjourney(Request $request)
    {   
         $data = DB::table('ourjourney')->where('id', $request->id)->first();
        
        $response = [
                    'success' => true,
                    'data' => $data
                ];
         return response()->json($response);
    }
    
}
