<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class PermissionsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_if(auth()->id() > 1, 404);
        $permissions = Permission::all();
        return view('backend.permission.index', compact('permissions'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_if(auth()->id() > 1, 404);
        return view('backend.permission.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(auth()->id() > 1, 404);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:permissions',
                'group' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $permission = new Permission();
        $permission->name = str_slug($request->name,'_');
        $permission->group = $request->group;
        $permission->save();
        return redirect()->back()->withInput()->with('success', __('Permission created'));
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort_if(auth()->id() > 1, 404);
        $permission = Permission::find($id);
        return view('backend.permission.edit', compact('permission'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort_if(auth()->id() > 1, 404);
        $permission = Permission::find($id);
        $validator = \Validator::make(
            $request->all(), [
                'name' => 'required|unique:permissions,name,' . $permission->id,
                'group' => 'required',
            ]
        );
        if($validator->fails())
        {
            $messages = $validator->getMessageBag();
            return redirect()->back()->withInput()->with('error', $messages->first());
        }
        $permission->name = str_slug($request->name,'_');
        $permission->group = $request->group;
        $permission->update();
        return redirect()->back()->with('success', 'Permission updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        abort_if(auth()->id() > 1, 404);
        Permission::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Permission deleted successfully');
    }
}
