<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MenuItem extends Model
{
    use HasFactory;
    protected $fillable = ['title','slug', 'url', 'parent_id', 'order', 'image','metatitle','metakeyword','metadescription'];

    public function children()
    {
        return $this->hasMany(MenuItem::class, 'parent_id')->with('children'); // Recursive relationship
    }

    public function parent()
    {
        return $this->belongsTo(MenuItem::class, 'parent_id');
    }
}
