<?php

namespace Database\Seeders;

use App\Models\Timezones;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TimezoneSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $timezones = [
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Amsterdam'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Andorra'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Europe/Astrakhan'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Athens'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Belgrade'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Berlin'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Bratislava'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Brussels'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Bucharest'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Budapest'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Busingen'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Chisinau'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Copenhagen'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Europe/Dublin'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Gibraltar'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Europe/Guernsey'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Helsinki'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Europe/Isle_of_Man'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Istanbul'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Europe/Jersey'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Kaliningrad'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Kiev'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Kirov'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Europe/Lisbon'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Ljubljana'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Europe/London'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Luxembourg'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Madrid'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Malta'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Mariehamn'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Minsk'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Monaco'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Moscow'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Oslo'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Paris'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Podgorica'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Prague'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Riga'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Rome'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Europe/Samara'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/San_Marino'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Sarajevo'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Europe/Saratov'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Simferopol'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Skopje'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Sofia'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Stockholm'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Tallinn'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Tirane'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Europe/Ulyanovsk'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Uzhgorod'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Vaduz'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Vatican'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Vienna'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Vilnius'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Volgograd'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Warsaw'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Zagreb'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Europe/Zaporozhye'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Europe/Zurich'
            ],
            [
                'time' => 'GMT/UTC -09:00',
                'name' => 'America/Adak'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'America/Anchorage'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Anguilla'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Antigua'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Araguaina'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Buenos_Aires'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Catamarca'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Cordoba'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Jujuy'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/La_Rioja'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Mendoza'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Rio_Gallegos'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Salta'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/San_Juan'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/San_Luis'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Tucuman'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Argentina/Ushuaia'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Aruba'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Asuncion'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Atikokan'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Bahia'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Bahia_Banderas'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Barbados'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Belem'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Belize'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Blanc-Sablon'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Boa_Vista'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Bogota'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Boise'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Cambridge_Bay'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Campo_Grande'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Cancun'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Caracas'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Cayenne'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Cayman'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Chicago'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Chihuahua'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Costa_Rica'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Creston'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Cuiaba'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Curacao'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'America/Danmarkshavn'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Dawson'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Dawson_Creek'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Denver'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Detroit'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Dominica'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Edmonton'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Eirunepe'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/El_Salvador'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Fort_Nelson'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Fortaleza'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Glace_Bay'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Goose_Bay'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Grand_Turk'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Grenada'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Guadeloupe'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Guatemala'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Guayaquil'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Guyana'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Halifax'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Havana'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Hermosillo'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Indiana/Indianapolis'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Indiana/Knox'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Indiana/Marengo'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Indiana/Petersburg'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Indiana/Tell_City'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Indiana/Vevay'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Indiana/Vincennes'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Indiana/Winamac'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Inuvik'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Iqaluit'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Jamaica'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'America/Juneau'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Kentucky/Louisville'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Kentucky/Monticello'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Kralendijk'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/La_Paz'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Lima'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Los_Angeles'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Lower_Princes'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Maceio'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Managua'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Manaus'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Marigot'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Martinique'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Matamoros'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Mazatlan'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Menominee'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Merida'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'America/Metlakatla'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Mexico_City'
            ],
            [
                'time' => 'GMT/UTC -02:00',
                'name' => 'America/Miquelon'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Moncton'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Monterrey'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Montevideo'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Montserrat'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Nassau'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/New_York'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Nipigon'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'America/Nome'
            ],
            [
                'time' => 'GMT/UTC -02:00',
                'name' => 'America/Noronha'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/North_Dakota/Beulah'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/North_Dakota/Center'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/North_Dakota/New_Salem'
            ],
            [
                'time' => 'GMT/UTC -02:00',
                'name' => 'America/Nuuk'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Ojinaga'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Panama'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Pangnirtung'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Paramaribo'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Phoenix'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Port-au-Prince'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Port_of_Spain'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Porto_Velho'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Puerto_Rico'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Punta_Arenas'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Rainy_River'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Rankin_Inlet'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Recife'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Regina'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Resolute'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Rio_Branco'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Santarem'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Santiago'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Santo_Domingo'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Sao_Paulo'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'America/Scoresbysund'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'America/Sitka'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/St_Barthelemy'
            ],
            [
                'time' => 'GMT/UTC -02:30',
                'name' => 'America/St_Johns'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/St_Kitts'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/St_Lucia'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/St_Thomas'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/St_Vincent'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Swift_Current'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Tegucigalpa'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'America/Thule'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Thunder_Bay'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Tijuana'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Toronto'
            ],
            [
                'time' => 'GMT/UTC -04:00',
                'name' => 'America/Tortola'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Vancouver'
            ],
            [
                'time' => 'GMT/UTC -07:00',
                'name' => 'America/Whitehorse'
            ],
            [
                'time' => 'GMT/UTC -05:00',
                'name' => 'America/Winnipeg'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'America/Yakutat'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'America/Yellowknife'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Indian/Antananarivo'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Indian/Chagos'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Indian/Christmas'
            ],
            [
                'time' => 'GMT/UTC +06:30',
                'name' => 'Indian/Cocos'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Indian/Comoro'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Indian/Kerguelen'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Indian/Mahe'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Indian/Maldives'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Indian/Mauritius'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Indian/Mayotte'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Indian/Reunion'
            ],
            [
                'time' => 'GMT/UTC +09:30',
                'name' => 'Australia/Adelaide'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Australia/Brisbane'
            ],
            [
                'time' => 'GMT/UTC +09:30',
                'name' => 'Australia/Broken_Hill'
            ],
            [
                'time' => 'GMT/UTC +09:30',
                'name' => 'Australia/Darwin'
            ],
            [
                'time' => 'GMT/UTC +08:45',
                'name' => 'Australia/Eucla'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Australia/Hobart'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Australia/Lindeman'
            ],
            [
                'time' => 'GMT/UTC +10:30',
                'name' => 'Australia/Lord_Howe'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Australia/Melbourne'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Australia/Perth'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Australia/Sydney'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Aden'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Almaty'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Amman'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Asia/Anadyr'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Aqtau'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Aqtobe'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Ashgabat'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Atyrau'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Baghdad'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Bahrain'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Asia/Baku'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Bangkok'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Barnaul'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Beirut'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Bishkek'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Brunei'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Chita'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Choibalsan'
            ],
            [
                'time' => 'GMT/UTC +05:30',
                'name' => 'Asia/Colombo'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Damascus'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Dhaka'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Dili'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Asia/Dubai'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Dushanbe'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Famagusta'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Gaza'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Hebron'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Ho_Chi_Minh'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Hong_Kong'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Hovd'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Irkutsk'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Jakarta'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Jayapura'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Jerusalem'
            ],
            [
                'time' => 'GMT/UTC +04:30',
                'name' => 'Asia/Kabul'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Asia/Kamchatka'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Karachi'
            ],
            [
                'time' => 'GMT/UTC +05:45',
                'name' => 'Asia/Kathmandu'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Khandyga'
            ],
            [
                'time' => 'GMT/UTC +05:30',
                'name' => 'Asia/Kolkata'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Krasnoyarsk'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Kuala_Lumpur'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Kuching'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Kuwait'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Macau'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Asia/Magadan'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Makassar'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Manila'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Asia/Muscat'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Nicosia'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Novokuznetsk'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Novosibirsk'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Omsk'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Oral'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Phnom_Penh'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Pontianak'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Pyongyang'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Qatar'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Qostanay'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Qyzylorda'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Asia/Riyadh'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Asia/Sakhalin'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Samarkand'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Seoul'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Shanghai'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Singapore'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Asia/Srednekolymsk'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Taipei'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Tashkent'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Asia/Tbilisi'
            ],
            [
                'time' => 'GMT/UTC +04:30',
                'name' => 'Asia/Tehran'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Thimphu'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Tokyo'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Tomsk'
            ],
            [
                'time' => 'GMT/UTC +08:00',
                'name' => 'Asia/Ulaanbaatar'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Asia/Urumqi'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Asia/Ust-Nera'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Asia/Vientiane'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Asia/Vladivostok'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Asia/Yakutsk'
            ],
            [
                'time' => 'GMT/UTC +06:30',
                'name' => 'Asia/Yangon'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Asia/Yekaterinburg'
            ],
            [
                'time' => 'GMT/UTC +04:00',
                'name' => 'Asia/Yerevan'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Abidjan'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Accra'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Addis_Ababa'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Algiers'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Asmara'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Bamako'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Bangui'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Banjul'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Bissau'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Blantyre'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Brazzaville'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Bujumbura'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Cairo'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Casablanca'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Ceuta'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Conakry'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Dakar'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Dar_es_Salaam'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Djibouti'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Douala'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/El_Aaiun'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Freetown'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Gaborone'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Harare'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Johannesburg'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Juba'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Kampala'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Khartoum'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Kigali'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Kinshasa'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Lagos'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Libreville'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Lome'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Luanda'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Lubumbashi'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Lusaka'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Malabo'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Maputo'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Maseru'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Mbabane'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Mogadishu'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Monrovia'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Africa/Nairobi'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Ndjamena'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Niamey'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Nouakchott'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Ouagadougou'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Porto-Novo'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Africa/Sao_Tome'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Tripoli'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Africa/Tunis'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Africa/Windhoek'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Antarctica/Casey'
            ],
            [
                'time' => 'GMT/UTC +07:00',
                'name' => 'Antarctica/Davis'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Antarctica/DumontDUrville'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Antarctica/Macquarie'
            ],
            [
                'time' => 'GMT/UTC +05:00',
                'name' => 'Antarctica/Mawson'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Antarctica/McMurdo'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'Antarctica/Palmer'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'Antarctica/Rothera'
            ],
            [
                'time' => 'GMT/UTC +03:00',
                'name' => 'Antarctica/Syowa'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Antarctica/Troll'
            ],
            [
                'time' => 'GMT/UTC +06:00',
                'name' => 'Antarctica/Vostok'
            ],
            [
                'time' => 'GMT/UTC +02:00',
                'name' => 'Arctic/Longyearbyen'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Atlantic/Azores'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'Atlantic/Bermuda'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Atlantic/Canary'
            ],
            [
                'time' => 'GMT/UTC -01:00',
                'name' => 'Atlantic/Cape_Verde'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Atlantic/Faroe'
            ],
            [
                'time' => 'GMT/UTC +01:00',
                'name' => 'Atlantic/Madeira'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Atlantic/Reykjavik'
            ],
            [
                'time' => 'GMT/UTC -02:00',
                'name' => 'Atlantic/South_Georgia'
            ],
            [
                'time' => 'GMT/UTC +00:00',
                'name' => 'Atlantic/St_Helena'
            ],
            [
                'time' => 'GMT/UTC -03:00',
                'name' => 'Atlantic/Stanley'
            ],
            [
                'time' => 'GMT/UTC +13:00',
                'name' => 'Pacific/Apia'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Auckland'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Bougainville'
            ],
            [
                'time' => 'GMT/UTC +12:45',
                'name' => 'Pacific/Chatham'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Pacific/Chuuk'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'Pacific/Easter'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Efate'
            ],
            [
                'time' => 'GMT/UTC +13:00',
                'name' => 'Pacific/Fakaofo'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Fiji'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Funafuti'
            ],
            [
                'time' => 'GMT/UTC -06:00',
                'name' => 'Pacific/Galapagos'
            ],
            [
                'time' => 'GMT/UTC -09:00',
                'name' => 'Pacific/Gambier'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Guadalcanal'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Pacific/Guam'
            ],
            [
                'time' => 'GMT/UTC -10:00',
                'name' => 'Pacific/Honolulu'
            ],
            [
                'time' => 'GMT/UTC +13:00',
                'name' => 'Pacific/Kanton'
            ],
            [
                'time' => 'GMT/UTC +14:00',
                'name' => 'Pacific/Kiritimati'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Kosrae'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Kwajalein'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Majuro'
            ],
            [
                'time' => 'GMT/UTC -09:30',
                'name' => 'Pacific/Marquesas'
            ],
            [
                'time' => 'GMT/UTC -11:00',
                'name' => 'Pacific/Midway'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Nauru'
            ],
            [
                'time' => 'GMT/UTC -11:00',
                'name' => 'Pacific/Niue'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Norfolk'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Noumea'
            ],
            [
                'time' => 'GMT/UTC -11:00',
                'name' => 'Pacific/Pago_Pago'
            ],
            [
                'time' => 'GMT/UTC +09:00',
                'name' => 'Pacific/Palau'
            ],
            [
                'time' => 'GMT/UTC -08:00',
                'name' => 'Pacific/Pitcairn'
            ],
            [
                'time' => 'GMT/UTC +11:00',
                'name' => 'Pacific/Pohnpei'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Pacific/Port_Moresby'
            ],
            [
                'time' => 'GMT/UTC -10:00',
                'name' => 'Pacific/Rarotonga'
            ],
            [
                'time' => 'GMT/UTC +10:00',
                'name' => 'Pacific/Saipan'
            ],
            [
                'time' => 'GMT/UTC -10:00',
                'name' => 'Pacific/Tahiti'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Tarawa'
            ],
            [
                'time' => 'GMT/UTC +13:00',
                'name' => 'Pacific/Tongatapu'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Wake'
            ],
            [
                'time' => 'GMT/UTC +12:00',
                'name' => 'Pacific/Wallis'
            ],
            [
                'time' => 'UTC',
                'name' => 'UTC'
            ],
        ];
        foreach($timezones as $timezone)
        {
            $timeArray = ['time' => $timezone['time'], 'name' => $timezone['name'], 'status' => 1];
            Timezones::updateOrCreate(
                [
                    'name' => $timezone['name']
                ], $timeArray
            );
        }
    }
}
