<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@example.com',
            'password' => Hash::make('123456789'),
            'type' => 'Superadmin'
        ]);

        $permissionData = [
            [
                'group' => 'Staff',
                'name' => 'manage_staff',
            ],
            [
                'group' => 'Staff',
                'name' => 'create_staff',
            ],
            [
                'group' => 'Staff',
                'name' => 'edit_staff',
            ],
            [
                'group' => 'Staff',
                'name' => 'delete_staff',
            ],
            [
                'group' => 'Staff',
                'name' => 'reset_staff_password',
            ],
            [
                'group' => 'Role',
                'name' => 'manage_role',
            ],
            [
                'group' => 'Role',
                'name' => 'create_role',
            ],
            [
                'group' => 'Role',
                'name' => 'edit_role',
            ],
            [
                'group' => 'Role',
                'name' => 'delete_role',
            ],
            [
                'group' => 'Settings',
                'name' => 'manage_site_settings',
            ],
            [
                'group' => 'Settings',
                'name' => 'smtp_settings',
            ],
            [
                'group' => 'Settings',
                'name' => 'footer_settings',
            ],
            [
                'group' => 'Blog',
                'name' => 'manage_blog_category',
            ],
            [
                'group' => 'Blog',
                'name' => 'create_blog_category',
            ],
            [
                'group' => 'Blog',
                'name' => 'edit_blog_category',
            ],
            [
                'group' => 'Blog',
                'name' => 'delete_blog_category',
            ],
            [
                'group' => 'Blog',
                'name' => 'manage_blog',
            ],
            [
                'group' => 'Blog',
                'name' => 'create_blog',
            ],
            [
                'group' => 'Blog',
                'name' => 'edit_blog',
            ],
            [
                'group' => 'Blog',
                'name' => 'delete_blog',
            ],
            [
                'group' => 'Enquires',
                'name' => 'manage_enquires',
            ],
            [
                'group' => 'Hero Section',
                'name' => 'manage_hero_section',
            ],
            [
                'group' => 'Hero Section',
                'name' => 'create_hero_section',
            ],
            [
                'group' => 'Hero Section',
                'name' => 'edit_hero_section',
            ],
            [
                'group' => 'Hero Section',
                'name' => 'delete_hero_section',
            ],
            [
                'group' => 'Office',
                'name' => 'manage_office',
            ],
            [
                'group' => 'Office',
                'name' => 'create_office',
            ],
            [
                'group' => 'Office',
                'name' => 'edit_office',
            ],
            [
                'group' => 'Office',
                'name' => 'delete_office',
            ],
            [
                'group' => 'FAQ',
                'name' => 'manage_faq'
            ],
            [
                'group' => 'FAQ',
                'name' => 'create_faq'
            ],
            [
                'group' => 'FAQ',
                'name' => 'edit_faq'
            ],
            [
                'group' => 'FAQ',
                'name' => 'delete_faq'
            ],
            [
                'group' => 'FAQ',
                'name' => 'manage_faq_category'
            ],
            [
                'group' => 'FAQ',
                'name' => 'create_faq_category'
            ],
            [
                'group' => 'FAQ',
                'name' => 'edit_faq_category'
            ],
            [
                'group' => 'FAQ',
                'name' => 'delete_faq_category'
            ],
            [
                'group' => 'Page Section',
                'name' => 'manage_page_section'
            ],
            [
                'group' => 'Page Section',
                'name' => 'create_page_section'
            ],
            [
                'group' => 'Page Section',
                'name' => 'edit_page_section'
            ],
            [
                'group' => 'Page Section',
                'name' => 'delete_page_section'
            ],
            [
                'group' => 'Pages',
                'name' => 'manage_pages'
            ],
            [
                'group' => 'Pages',
                'name' => 'create_pages'
            ],
            [
                'group' => 'Pages',
                'name' => 'edit_pages'
            ],
            [
                'group' => 'Pages',
                'name' => 'delete_pages'
            ],
            [
                'group' => 'Team Members',
                'name' => 'manage_team_members'
            ],
            [
                'group' => 'Team Members',
                'name' => 'create_team_members'
            ],
            [
                'group' => 'Team Members',
                'name' => 'edit_team_members'
            ],
            [
                'group' => 'Team Members',
                'name' => 'delete_team_members'
            ],
            [
                'group' => 'Partners',
                'name' => 'manage_partners'
            ],
            [
                'group' => 'Partners',
                'name' => 'create_partners'
            ],
            [
                'group' => 'Partners',
                'name' => 'edit_partners'
            ],
            [
                'group' => 'Partners',
                'name' => 'delete_partners'
            ],
            [
                'group' => 'Menu Management',
                'name' => 'manage_menu'
            ],
            [
                'group' => 'Menu',
                'name' => 'create_menu'
            ],
            [
                'group' => 'Menu',
                'name' => 'edit_menu'
            ],
            [
                'group' => 'Menu',
                'name' => 'delete_menu'
            ],
        ];

        foreach ($permissionData as $permissionValue) {
            $permission = new Permission();
            $permission->name = $permissionValue['name'];
            $permission->group = $permissionValue['group'];
            $permission->guard_name = 'web';
            $permission->save();
        }

        $role = Role::create(['name' => 'Superadmin']);

        $permissions = Permission::pluck('id','id')->all();

        $role->syncPermissions($permissions);

        $user->assignRole([$role->id]);
    }
}
