/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/assets/core/js/custom/apps/calendar/calendar.js":
/*!*******************************************************************!*\
  !*** ./resources/assets/core/js/custom/apps/calendar/calendar.js ***!
  \*******************************************************************/
/***/ (() => {

eval("\n\n// Class definition\nvar KTAppCalendar = function () {\n  // Shared variables\n  // Calendar variables\n  var calendar;\n  var data = {\n    id: '',\n    eventName: '',\n    eventDescription: '',\n    eventLocation: '',\n    startDate: '',\n    endDate: '',\n    allDay: false\n  };\n\n  // Add event variables\n  var eventName;\n  var eventDescription;\n  var eventLocation;\n  var startDatepicker;\n  var startFlatpickr;\n  var endDatepicker;\n  var endFlatpickr;\n  var startTimepicker;\n  var startTimeFlatpickr;\n  var endTimepicker;\n  var endTimeFlatpickr;\n  var modal;\n  var modalTitle;\n  var form;\n  var validator;\n  var addButton;\n  var submitButton;\n  var cancelButton;\n  var closeButton;\n\n  // View event variables\n  var viewEventName;\n  var viewAllDay;\n  var viewEventDescription;\n  var viewEventLocation;\n  var viewStartDate;\n  var viewEndDate;\n  var viewModal;\n  var viewEditButton;\n  var viewDeleteButton;\n\n  // Private functions\n  var initCalendarApp = function initCalendarApp() {\n    // Define variables\n    var calendarEl = document.getElementById('kt_calendar_app');\n    var todayDate = moment().startOf('day');\n    var YM = todayDate.format('YYYY-MM');\n    var YESTERDAY = todayDate.clone().subtract(1, 'day').format('YYYY-MM-DD');\n    var TODAY = todayDate.format('YYYY-MM-DD');\n    var TOMORROW = todayDate.clone().add(1, 'day').format('YYYY-MM-DD');\n\n    // Init calendar --- more info: https://fullcalendar.io/docs/initialize-globals\n    calendar = new FullCalendar.Calendar(calendarEl, {\n      //locale: 'es', // Set local --- more info: https://fullcalendar.io/docs/locale\n      headerToolbar: {\n        left: 'prev,next today',\n        center: 'title',\n        right: 'dayGridMonth,timeGridWeek,timeGridDay'\n      },\n      initialDate: TODAY,\n      navLinks: true,\n      // can click day/week names to navigate views\n      selectable: true,\n      selectMirror: true,\n      // Select dates action --- more info: https://fullcalendar.io/docs/select-callback\n      select: function select(arg) {\n        formatArgs(arg);\n        handleNewEvent();\n      },\n      // Click event --- more info: https://fullcalendar.io/docs/eventClick\n      eventClick: function eventClick(arg) {\n        formatArgs({\n          id: arg.event.id,\n          title: arg.event.title,\n          description: arg.event.extendedProps.description,\n          location: arg.event.extendedProps.location,\n          startStr: arg.event.startStr,\n          endStr: arg.event.endStr,\n          allDay: arg.event.allDay\n        });\n        handleViewEvent();\n      },\n      editable: true,\n      dayMaxEvents: true,\n      // allow \"more\" link when too many events\n      events: [{\n        id: uid(),\n        title: 'All Day Event',\n        start: YM + '-01',\n        end: YM + '-02',\n        description: 'Toto lorem ipsum dolor sit incid idunt ut',\n        className: \"fc-event-danger fc-event-solid-warning\",\n        location: 'Federation Square'\n      }, {\n        id: uid(),\n        title: 'Reporting',\n        start: YM + '-14T13:30:00',\n        description: 'Lorem ipsum dolor incid idunt ut labore',\n        end: YM + '-14T14:30:00',\n        className: \"fc-event-success\",\n        location: 'Meeting Room 7.03'\n      }, {\n        id: uid(),\n        title: 'Company Trip',\n        start: YM + '-02',\n        description: 'Lorem ipsum dolor sit tempor incid',\n        end: YM + '-03',\n        className: \"fc-event-primary\",\n        location: 'Seoul, Korea'\n      }, {\n        id: uid(),\n        title: 'ICT Expo 2021 - Product Release',\n        start: YM + '-03',\n        description: 'Lorem ipsum dolor sit tempor inci',\n        end: YM + '-05',\n        className: \"fc-event-light fc-event-solid-primary\",\n        location: 'Melbourne Exhibition Hall'\n      }, {\n        id: uid(),\n        title: 'Dinner',\n        start: YM + '-12',\n        description: 'Lorem ipsum dolor sit amet, conse ctetur',\n        end: YM + '-13',\n        location: 'Squire\\'s Loft'\n      }, {\n        id: uid(),\n        title: 'Repeating Event',\n        start: YM + '-09T16:00:00',\n        end: YM + '-09T17:00:00',\n        description: 'Lorem ipsum dolor sit ncididunt ut labore',\n        className: \"fc-event-danger\",\n        location: 'General Area'\n      }, {\n        id: uid(),\n        title: 'Repeating Event',\n        description: 'Lorem ipsum dolor sit amet, labore',\n        start: YM + '-16T16:00:00',\n        end: YM + '-16T17:00:00',\n        location: 'General Area'\n      }, {\n        id: uid(),\n        title: 'Conference',\n        start: YESTERDAY,\n        end: TOMORROW,\n        description: 'Lorem ipsum dolor eius mod tempor labore',\n        className: \"fc-event-primary\",\n        location: 'Conference Hall A'\n      }, {\n        id: uid(),\n        title: 'Meeting',\n        start: TODAY + 'T10:30:00',\n        end: TODAY + 'T12:30:00',\n        description: 'Lorem ipsum dolor eiu idunt ut labore',\n        location: 'Meeting Room 11.06'\n      }, {\n        id: uid(),\n        title: 'Lunch',\n        start: TODAY + 'T12:00:00',\n        end: TODAY + 'T14:00:00',\n        className: \"fc-event-info\",\n        description: 'Lorem ipsum dolor sit amet, ut labore',\n        location: 'Cafeteria'\n      }, {\n        id: uid(),\n        title: 'Meeting',\n        start: TODAY + 'T14:30:00',\n        end: TODAY + 'T15:30:00',\n        className: \"fc-event-warning\",\n        description: 'Lorem ipsum conse ctetur adipi scing',\n        location: 'Meeting Room 11.10'\n      }, {\n        id: uid(),\n        title: 'Happy Hour',\n        start: TODAY + 'T17:30:00',\n        end: TODAY + 'T21:30:00',\n        className: \"fc-event-info\",\n        description: 'Lorem ipsum dolor sit amet, conse ctetur',\n        location: 'The English Pub'\n      }, {\n        id: uid(),\n        title: 'Dinner',\n        start: TOMORROW + 'T18:00:00',\n        end: TOMORROW + 'T21:00:00',\n        className: \"fc-event-solid-danger fc-event-light\",\n        description: 'Lorem ipsum dolor sit ctetur adipi scing',\n        location: 'New York Steakhouse'\n      }, {\n        id: uid(),\n        title: 'Birthday Party',\n        start: TOMORROW + 'T12:00:00',\n        end: TOMORROW + 'T14:00:00',\n        className: \"fc-event-primary\",\n        description: 'Lorem ipsum dolor sit amet, scing',\n        location: 'The English Pub'\n      }, {\n        id: uid(),\n        title: 'Site visit',\n        start: YM + '-28',\n        end: YM + '-29',\n        className: \"fc-event-solid-info fc-event-light\",\n        description: 'Lorem ipsum dolor sit amet, labore',\n        location: '271, Spring Street'\n      }],\n      // Handle changing calendar views --- more info: https://fullcalendar.io/docs/datesSet\n      datesSet: function datesSet() {\n        // do some stuff\n      }\n    });\n    calendar.render();\n  };\n\n  // Init validator\n  var initValidator = function initValidator() {\n    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/\n    validator = FormValidation.formValidation(form, {\n      fields: {\n        'calendar_event_name': {\n          validators: {\n            notEmpty: {\n              message: 'Event name is required'\n            }\n          }\n        },\n        'calendar_event_start_date': {\n          validators: {\n            notEmpty: {\n              message: 'Start date is required'\n            }\n          }\n        },\n        'calendar_event_end_date': {\n          validators: {\n            notEmpty: {\n              message: 'End date is required'\n            }\n          }\n        }\n      },\n      plugins: {\n        trigger: new FormValidation.plugins.Trigger(),\n        bootstrap: new FormValidation.plugins.Bootstrap5({\n          rowSelector: '.fv-row',\n          eleInvalidClass: '',\n          eleValidClass: ''\n        })\n      }\n    });\n  };\n\n  // Initialize datepickers --- more info: https://flatpickr.js.org/\n  var initDatepickers = function initDatepickers() {\n    startFlatpickr = flatpickr(startDatepicker, {\n      enableTime: false,\n      dateFormat: \"Y-m-d\"\n    });\n    endFlatpickr = flatpickr(endDatepicker, {\n      enableTime: false,\n      dateFormat: \"Y-m-d\"\n    });\n    startTimeFlatpickr = flatpickr(startTimepicker, {\n      enableTime: true,\n      noCalendar: true,\n      dateFormat: \"H:i\"\n    });\n    endTimeFlatpickr = flatpickr(endTimepicker, {\n      enableTime: true,\n      noCalendar: true,\n      dateFormat: \"H:i\"\n    });\n  };\n\n  // Handle add button\n  var handleAddButton = function handleAddButton() {\n    addButton.addEventListener('click', function (e) {\n      // Reset form data\n      data = {\n        id: '',\n        eventName: '',\n        eventDescription: '',\n        startDate: new Date(),\n        endDate: new Date(),\n        allDay: false\n      };\n      handleNewEvent();\n    });\n  };\n\n  // Handle add new event\n  var handleNewEvent = function handleNewEvent() {\n    // Update modal title\n    modalTitle.innerText = \"Add a New Event\";\n    modal.show();\n\n    // Select datepicker wrapper elements\n    var datepickerWrappers = form.querySelectorAll('[data-kt-calendar=\"datepicker\"]');\n\n    // Handle all day toggle\n    var allDayToggle = form.querySelector('#kt_calendar_datepicker_allday');\n    allDayToggle.addEventListener('click', function (e) {\n      if (e.target.checked) {\n        datepickerWrappers.forEach(function (dw) {\n          dw.classList.add('d-none');\n        });\n      } else {\n        endFlatpickr.setDate(data.startDate, true, 'Y-m-d');\n        datepickerWrappers.forEach(function (dw) {\n          dw.classList.remove('d-none');\n        });\n      }\n    });\n    populateForm(data);\n\n    // Handle submit form\n    submitButton.addEventListener('click', function (e) {\n      // Prevent default button action\n      e.preventDefault();\n\n      // Validate form before submit\n      if (validator) {\n        validator.validate().then(function (status) {\n          console.log('validated!');\n          if (status == 'Valid') {\n            // Show loading indication\n            submitButton.setAttribute('data-kt-indicator', 'on');\n\n            // Disable submit button whilst loading\n            submitButton.disabled = true;\n\n            // Simulate form submission\n            setTimeout(function () {\n              // Simulate form submission\n              submitButton.removeAttribute('data-kt-indicator');\n\n              // Show popup confirmation \n              Swal.fire({\n                text: \"New event added to calendar!\",\n                icon: \"success\",\n                buttonsStyling: false,\n                confirmButtonText: \"Ok, got it!\",\n                customClass: {\n                  confirmButton: \"btn btn-primary\"\n                }\n              }).then(function (result) {\n                if (result.isConfirmed) {\n                  modal.hide();\n\n                  // Enable submit button after loading\n                  submitButton.disabled = false;\n\n                  // Detect if is all day event\n                  var allDayEvent = false;\n                  if (allDayToggle.checked) {\n                    allDayEvent = true;\n                  }\n                  if (startTimeFlatpickr.selectedDates.length === 0) {\n                    allDayEvent = true;\n                  }\n\n                  // Merge date & time\n                  var startDateTime = moment(startFlatpickr.selectedDates[0]).format();\n                  var endDateTime = moment(endFlatpickr.selectedDates[endFlatpickr.selectedDates.length - 1]).format();\n                  if (!allDayEvent) {\n                    var startDate = moment(startFlatpickr.selectedDates[0]).format('YYYY-MM-DD');\n                    var endDate = startDate;\n                    var startTime = moment(startTimeFlatpickr.selectedDates[0]).format('HH:mm:ss');\n                    var endTime = moment(endTimeFlatpickr.selectedDates[0]).format('HH:mm:ss');\n                    startDateTime = startDate + 'T' + startTime;\n                    endDateTime = endDate + 'T' + endTime;\n                  }\n\n                  // Add new event to calendar\n                  calendar.addEvent({\n                    id: uid(),\n                    title: eventName.value,\n                    description: eventDescription.value,\n                    location: eventLocation.value,\n                    start: startDateTime,\n                    end: endDateTime,\n                    allDay: allDayEvent\n                  });\n                  calendar.render();\n\n                  // Reset form for demo purposes only\n                  form.reset();\n                }\n              });\n\n              //form.submit(); // Submit form\n            }, 2000);\n          } else {\n            // Show popup warning \n            Swal.fire({\n              text: \"Sorry, looks like there are some errors detected, please try again.\",\n              icon: \"error\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn btn-primary\"\n              }\n            });\n          }\n        });\n      }\n    });\n  };\n\n  // Handle edit event\n  var handleEditEvent = function handleEditEvent() {\n    // Update modal title\n    modalTitle.innerText = \"Edit an Event\";\n    modal.show();\n\n    // Select datepicker wrapper elements\n    var datepickerWrappers = form.querySelectorAll('[data-kt-calendar=\"datepicker\"]');\n\n    // Handle all day toggle\n    var allDayToggle = form.querySelector('#kt_calendar_datepicker_allday');\n    allDayToggle.addEventListener('click', function (e) {\n      if (e.target.checked) {\n        datepickerWrappers.forEach(function (dw) {\n          dw.classList.add('d-none');\n        });\n      } else {\n        endFlatpickr.setDate(data.startDate, true, 'Y-m-d');\n        datepickerWrappers.forEach(function (dw) {\n          dw.classList.remove('d-none');\n        });\n      }\n    });\n    populateForm(data);\n\n    // Handle submit form\n    submitButton.addEventListener('click', function (e) {\n      // Prevent default button action\n      e.preventDefault();\n\n      // Validate form before submit\n      if (validator) {\n        validator.validate().then(function (status) {\n          console.log('validated!');\n          if (status == 'Valid') {\n            // Show loading indication\n            submitButton.setAttribute('data-kt-indicator', 'on');\n\n            // Disable submit button whilst loading\n            submitButton.disabled = true;\n\n            // Simulate form submission\n            setTimeout(function () {\n              // Simulate form submission\n              submitButton.removeAttribute('data-kt-indicator');\n\n              // Show popup confirmation \n              Swal.fire({\n                text: \"New event added to calendar!\",\n                icon: \"success\",\n                buttonsStyling: false,\n                confirmButtonText: \"Ok, got it!\",\n                customClass: {\n                  confirmButton: \"btn btn-primary\"\n                }\n              }).then(function (result) {\n                if (result.isConfirmed) {\n                  modal.hide();\n\n                  // Enable submit button after loading\n                  submitButton.disabled = false;\n\n                  // Remove old event\n                  calendar.getEventById(data.id).remove();\n\n                  // Detect if is all day event\n                  var allDayEvent = false;\n                  if (allDayToggle.checked) {\n                    allDayEvent = true;\n                  }\n                  if (startTimeFlatpickr.selectedDates.length === 0) {\n                    allDayEvent = true;\n                  }\n\n                  // Merge date & time\n                  var startDateTime = moment(startFlatpickr.selectedDates[0]).format();\n                  var endDateTime = moment(endFlatpickr.selectedDates[endFlatpickr.selectedDates.length - 1]).format();\n                  if (!allDayEvent) {\n                    var startDate = moment(startFlatpickr.selectedDates[0]).format('YYYY-MM-DD');\n                    var endDate = startDate;\n                    var startTime = moment(startTimeFlatpickr.selectedDates[0]).format('HH:mm:ss');\n                    var endTime = moment(endTimeFlatpickr.selectedDates[0]).format('HH:mm:ss');\n                    startDateTime = startDate + 'T' + startTime;\n                    endDateTime = endDate + 'T' + endTime;\n                  }\n\n                  // Add new event to calendar\n                  calendar.addEvent({\n                    id: uid(),\n                    title: eventName.value,\n                    description: eventDescription.value,\n                    location: eventLocation.value,\n                    start: startDateTime,\n                    end: endDateTime,\n                    allDay: allDayEvent\n                  });\n                  calendar.render();\n\n                  // Reset form for demo purposes only\n                  form.reset();\n                }\n              });\n\n              //form.submit(); // Submit form\n            }, 2000);\n          } else {\n            // Show popup warning \n            Swal.fire({\n              text: \"Sorry, looks like there are some errors detected, please try again.\",\n              icon: \"error\",\n              buttonsStyling: false,\n              confirmButtonText: \"Ok, got it!\",\n              customClass: {\n                confirmButton: \"btn btn-primary\"\n              }\n            });\n          }\n        });\n      }\n    });\n  };\n\n  // Handle view event\n  var handleViewEvent = function handleViewEvent() {\n    viewModal.show();\n\n    // Detect all day event\n    var eventNameMod;\n    var startDateMod;\n    var endDateMod;\n\n    // Generate labels\n    if (data.allDay) {\n      eventNameMod = 'All Day';\n      startDateMod = moment(data.startDate).format('Do MMM, YYYY');\n      endDateMod = moment(data.endDate).format('Do MMM, YYYY');\n    } else {\n      eventNameMod = '';\n      startDateMod = moment(data.startDate).format('Do MMM, YYYY - h:mm a');\n      endDateMod = moment(data.endDate).format('Do MMM, YYYY - h:mm a');\n    }\n\n    // Populate view data\n    viewEventName.innerText = data.eventName;\n    viewAllDay.innerText = eventNameMod;\n    viewEventDescription.innerText = data.eventDescription ? data.eventDescription : '--';\n    viewEventLocation.innerText = data.eventLocation ? data.eventLocation : '--';\n    viewStartDate.innerText = startDateMod;\n    viewEndDate.innerText = endDateMod;\n  };\n\n  // Handle delete event\n  var handleDeleteEvent = function handleDeleteEvent() {\n    viewDeleteButton.addEventListener('click', function (e) {\n      e.preventDefault();\n      Swal.fire({\n        text: \"Are you sure you would like to delete this event?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        confirmButtonText: \"Yes, delete it!\",\n        cancelButtonText: \"No, return\",\n        customClass: {\n          confirmButton: \"btn btn-primary\",\n          cancelButton: \"btn btn-active-light\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          calendar.getEventById(data.id).remove();\n          viewModal.hide(); // Hide modal\t\t\t\t\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Your event was not deleted!.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn btn-primary\"\n            }\n          });\n        }\n      });\n    });\n  };\n\n  // Handle edit button\n  var handleEditButton = function handleEditButton() {\n    viewEditButton.addEventListener('click', function (e) {\n      e.preventDefault();\n      viewModal.hide();\n      handleEditEvent();\n    });\n  };\n\n  // Handle cancel button\n  var handleCancelButton = function handleCancelButton() {\n    // Edit event modal cancel button\n    cancelButton.addEventListener('click', function (e) {\n      e.preventDefault();\n      Swal.fire({\n        text: \"Are you sure you would like to cancel?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        confirmButtonText: \"Yes, cancel it!\",\n        cancelButtonText: \"No, return\",\n        customClass: {\n          confirmButton: \"btn btn-primary\",\n          cancelButton: \"btn btn-active-light\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          form.reset(); // Reset form\t\n          modal.hide(); // Hide modal\t\t\t\t\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Your form has not been cancelled!.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn btn-primary\"\n            }\n          });\n        }\n      });\n    });\n  };\n\n  // Handle close button\n  var handleCloseButton = function handleCloseButton() {\n    // Edit event modal close button\n    closeButton.addEventListener('click', function (e) {\n      e.preventDefault();\n      Swal.fire({\n        text: \"Are you sure you would like to cancel?\",\n        icon: \"warning\",\n        showCancelButton: true,\n        buttonsStyling: false,\n        confirmButtonText: \"Yes, cancel it!\",\n        cancelButtonText: \"No, return\",\n        customClass: {\n          confirmButton: \"btn btn-primary\",\n          cancelButton: \"btn btn-active-light\"\n        }\n      }).then(function (result) {\n        if (result.value) {\n          form.reset(); // Reset form\t\n          modal.hide(); // Hide modal\t\t\t\t\n        } else if (result.dismiss === 'cancel') {\n          Swal.fire({\n            text: \"Your form has not been cancelled!.\",\n            icon: \"error\",\n            buttonsStyling: false,\n            confirmButtonText: \"Ok, got it!\",\n            customClass: {\n              confirmButton: \"btn btn-primary\"\n            }\n          });\n        }\n      });\n    });\n  };\n\n  // Handle view button\n  var handleViewButton = function handleViewButton() {\n    var viewButton = document.querySelector('#kt_calendar_event_view_button');\n    viewButton.addEventListener('click', function (e) {\n      e.preventDefault();\n      hidePopovers();\n      handleViewEvent();\n    });\n  };\n\n  // Helper functions\n\n  // Reset form validator on modal close\n  var resetFormValidator = function resetFormValidator(element) {\n    // Target modal hidden event --- For more info: https://getbootstrap.com/docs/5.0/components/modal/#events\n    element.addEventListener('hidden.bs.modal', function (e) {\n      if (validator) {\n        // Reset form validator. For more info: https://formvalidation.io/guide/api/reset-form\n        validator.resetForm(true);\n      }\n    });\n  };\n\n  // Populate form \n  var populateForm = function populateForm() {\n    eventName.value = data.eventName ? data.eventName : '';\n    eventDescription.value = data.eventDescription ? data.eventDescription : '';\n    eventLocation.value = data.eventLocation ? data.eventLocation : '';\n    startFlatpickr.setDate(data.startDate, true, 'Y-m-d');\n\n    // Handle null end dates\n    var endDate = data.endDate ? data.endDate : moment(data.startDate).format();\n    endFlatpickr.setDate(endDate, true, 'Y-m-d');\n    var allDayToggle = form.querySelector('#kt_calendar_datepicker_allday');\n    var datepickerWrappers = form.querySelectorAll('[data-kt-calendar=\"datepicker\"]');\n    if (data.allDay) {\n      allDayToggle.checked = true;\n      datepickerWrappers.forEach(function (dw) {\n        dw.classList.add('d-none');\n      });\n    } else {\n      startTimeFlatpickr.setDate(data.startDate, true, 'Y-m-d H:i');\n      endTimeFlatpickr.setDate(data.endDate, true, 'Y-m-d H:i');\n      endFlatpickr.setDate(data.startDate, true, 'Y-m-d');\n      allDayToggle.checked = false;\n      datepickerWrappers.forEach(function (dw) {\n        dw.classList.remove('d-none');\n      });\n    }\n  };\n\n  // Format FullCalendar reponses\n  var formatArgs = function formatArgs(res) {\n    data.id = res.id;\n    data.eventName = res.title;\n    data.eventDescription = res.description;\n    data.eventLocation = res.location;\n    data.startDate = res.startStr;\n    data.endDate = res.endStr;\n    data.allDay = res.allDay;\n  };\n\n  // Generate unique IDs for events\n  var uid = function uid() {\n    return Date.now().toString() + Math.floor(Math.random() * 1000).toString();\n  };\n  return {\n    // Public Functions\n    init: function init() {\n      // Define variables\n      // Add event modal\n      var element = document.getElementById('kt_modal_add_event');\n      form = element.querySelector('#kt_modal_add_event_form');\n      eventName = form.querySelector('[name=\"calendar_event_name\"]');\n      eventDescription = form.querySelector('[name=\"calendar_event_description\"]');\n      eventLocation = form.querySelector('[name=\"calendar_event_location\"]');\n      startDatepicker = form.querySelector('#kt_calendar_datepicker_start_date');\n      endDatepicker = form.querySelector('#kt_calendar_datepicker_end_date');\n      startTimepicker = form.querySelector('#kt_calendar_datepicker_start_time');\n      endTimepicker = form.querySelector('#kt_calendar_datepicker_end_time');\n      addButton = document.querySelector('[data-kt-calendar=\"add\"]');\n      submitButton = form.querySelector('#kt_modal_add_event_submit');\n      cancelButton = form.querySelector('#kt_modal_add_event_cancel');\n      closeButton = element.querySelector('#kt_modal_add_event_close');\n      modalTitle = form.querySelector('[data-kt-calendar=\"title\"]');\n      modal = new bootstrap.Modal(element);\n\n      // View event modal\n      var viewElement = document.getElementById('kt_modal_view_event');\n      viewModal = new bootstrap.Modal(viewElement);\n      viewEventName = viewElement.querySelector('[data-kt-calendar=\"event_name\"]');\n      viewAllDay = viewElement.querySelector('[data-kt-calendar=\"all_day\"]');\n      viewEventDescription = viewElement.querySelector('[data-kt-calendar=\"event_description\"]');\n      viewEventLocation = viewElement.querySelector('[data-kt-calendar=\"event_location\"]');\n      viewStartDate = viewElement.querySelector('[data-kt-calendar=\"event_start_date\"]');\n      viewEndDate = viewElement.querySelector('[data-kt-calendar=\"event_end_date\"]');\n      viewEditButton = viewElement.querySelector('#kt_modal_view_event_edit');\n      viewDeleteButton = viewElement.querySelector('#kt_modal_view_event_delete');\n      initCalendarApp();\n      initValidator();\n      initDatepickers();\n      handleEditButton();\n      handleAddButton();\n      handleDeleteEvent();\n      handleCancelButton();\n      handleCloseButton();\n      resetFormValidator(element);\n    }\n  };\n}();\n\n// On document ready\nKTUtil.onDOMContentLoaded(function () {\n  KTAppCalendar.init();\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./resources/assets/core/js/custom/apps/calendar/calendar.js\n");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval-source-map devtool is used.
/******/ 	var __webpack_exports__ = {};
/******/ 	__webpack_modules__["./resources/assets/core/js/custom/apps/calendar/calendar.js"]();
/******/ 	
/******/ })()
;