@extends('layouts.auth')
<style>
    #kt_app_root .d-flex.flex-column.flex-lg-row.flex-column-fluid{
            justify-content: center;
    }
    #kt_app_root .bg-body.d-flex.flex-column.flex-center.rounded-4.w-md-600px.p-10{
        padding: 2rem 2rem !important;
        max-width: 100%;
        width: 500px !important;
            height: min-content;
    }
    #kt_app_root .d-flex.flex-column-fluid.flex-lg-row-auto.justify-content-center.justify-content-lg-end.p-12{
            align-items: center;
    }
    #kt_app_root .d-flex.flex-center.flex-column.align-items-stretch.h-lg-100.w-md-400px{
            width: 100% !important;
    }
    #kt_app_root .d-flex.flex-center.flex-column-fluid.pb-15.pb-lg-20{
            padding: unset !important;
        margin-bottom: unset !important;
    }
    #kt_app_root form .text-center h1{
            text-align: justify;
    margin-top: 1rem;
    }
    #kt_app_root form label{
            margin-bottom: 0.5rem;
    }
    #kt_app_root form .end-0 {
        right: 0% !important;
    }
    
    #kt_app_root form .top-50 {
        top: 69% !important;
    }
    @media only screen and (max-width: 600px) {
      #kt_app_root .d-flex.flex-column-fluid.flex-lg-row-auto.justify-content-center.justify-content-lg-end.p-12 {
            padding: 1.5rem !important;
        }
        #kt_app_root .bg-body.d-flex.flex-column.flex-center.rounded-4.w-md-600px.p-10 {
    padding: 1.5rem 1.5rem !important;
        }
    }
</style>
@section('content')

<form class="form w-100" method="POST" novalidate="novalidate" id="kt_sign_in_form1" action="{{ route('login') }}">
    @csrf
    <div class="text-center mb-11">
        <img src="{{ asset('assets/media/img/elevate.png') }}" class="mb-3 logoadmins" style="max-width: 25%;"/>
        <h1 class="text-dark fw-bolder mb-3">Sign In</h1>
    </div>
    <div class="fv-row mb-8 fv-plugins-icon-container fv-plugins-bootstrap5-row-valid">
        <label for="">Enter your email</label>
        <input type="text" placeholder="Email" name="email" autocomplete="off" class="form-control bg-transparent @error('email') is-invalid @enderror" value="{{ old('email')}}" required autofocus>
        @error('email')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
    <div class="fv-row mb-3 fv-plugins-icon-container fv-plugins-bootstrap5-row-valid">
        <div class="position-relative mb-3">
            <label>Enter password</label>
            <input id="password" type="password" placeholder="Password" name="password" autocomplete="off" class="form-control bg-transparent @error('password') is-invalid @enderror" >
            <span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2">
                <i class="bi bi-eye-slash show-password fs-2"></i>
                <i class="bi bi-eye fs-2 hide-password" style="display:none;"></i>
            </span>
            @error('password')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>
    <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">
        <div></div>
        @if (Route::has('password.request') && get_setting('enable_email'))
            <a href="{{ route('password.request') }}" class="link-primary">Forgot Password ?</a>
        @endif
    </div>
    <div class="d-grid mb-10">
        <button type="submit" id="kt_sign_in_submit" class="btn btn-primary" style="background-color: #002850;">
        <span class="indicator-label">
            {{ __('Login') }}
        </span>
        </button>
    </div>
    <div class="text-gray-500 text-center fw-semibold fs-6">Not a Member yet?
        <a href="{{ route('register') }}" class="link-primary" style="color: #002850 !important;">Sign up</a></div>
    <div></div>
</form>
@endsection
@push('java-script')
<script>
    $(document).ready(function()
    {
        $(".show-password, .hide-password").on('click', function() {
            var passwordId = $(this).parent().parent().find('input').attr('id');
            if ($(this).hasClass('show-password')) {
                $("#" + passwordId).attr("type", "text");
                $(this).parent().find(".show-password").hide();
                $(this).parent().find(".hide-password").show();
            } else {
                $("#" + passwordId).attr("type", "password");
                $(this).parent().find(".hide-password").hide();
                $(this).parent().find(".show-password").show();
            }
        });
    });
</script>
@endpush
