@extends('layouts.dashboard')
@section('toolbar-heading','Approved Auditors')
@section('breadcrumb','Home')
@section('breadcrumb1','Approved Auditors')
@section('action-btn')
    <a href="{{ route('approved-auditors.create') }}" class="btn btn-sm btn-primary">Create</a>

@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">Image</th>
                    
                    <th class="min-w-125px">Link</th>
                   
                        <th class="text-end min-w-70px">Actions</th>
                    
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600 cursor-move" id="sortable">
                @foreach($approved as $key => $approveds)
                    <tr data-index-no="{{ $approveds->id }}">
                        <td><img src="{{ get_file('approved-auditors',$approveds->image) }}" width="60px" height="60px" alt="Image"></td>
                         
                        <td>{{ $approveds->link }}</td>
                        
                       
                            <td class="text-end">
                                
                                    <a href="{{ route('approved-auditors.edit',$approveds->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                
                                    <a href="#" onclick="delete_this('{{route('approved-auditors.destroy',$approveds->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                
                            </td>
                       
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.3/jquery-ui.min.js"></script>
    <script>
        //$('#sortable').dataTable();
       

        $('#sortable').sortable({
            axis: 'y',
            stop: function (event, ui) {
                var order = [];
                $('tr').each(function() {
                    if($(this).data('index-no') != undefined) {
                        order.push($(this).data('index-no'));
                    }
                });
                $.ajax({
                    url: "{{route('sort-company-section')}}",
                    data: {
                        _token: '{{ csrf_token() }}',
                        order: order,
                    },
                    type: 'POST',
                    error: function (data) {
                        createToast('error', 'Something went wrong!');
                    }
                });
            }
        });
    </script>
@endpush
