@extends('layouts.dashboard')
@section('toolbar-heading','Hero Section')
@section('breadcrumb','Home')
@section('breadcrumb1','Hero Section')
@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title fs-3 fw-bold">Create Hero Section</div>
        </div>
        <form id="kt_project_settings_form" action="{{ route('hero-section.store') }}" class="form" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card-body p-9">
                <div class="row mb-5" id="image-div">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Image</div>
                    </div>
                    <div class="col-lg-8">
                        <div class="image-input image-input-outline image-input-empty" data-kt-image-input="true" style="">
                            <div class="image-input-wrapper w-125px h-125px bgi-position-center" style="" id="img-div"></div>
                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                                <i class="bi bi-pencil-fill fs-7"></i>
                                <input type="file" id="image" name="image" accept=".png, .jpg, .jpeg,.webp" />
                                <input type="hidden" name="image_remove" />
                            </label>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                        </div>
                        <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                        <input type="hidden" name="content_image" id="content_image" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Title</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" name="title" id="title" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Description</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" name="description" id="description" />
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Status</div>
                    </div>
                    <div class="col-xl-9">
                        <div class="form-check form-switch form-check-custom form-check-solid">
                            <input class="form-check-input" type="checkbox" id="status" name="status" />
                            <label class="form-check-label fw-semibold text-gray-400 ms-3" for="status"></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Save</button>
            </div>
        </form>
    </div>
@endsection
