@extends('layouts.dashboard')
@section('toolbar-heading','Career')
@section('breadcrumb','Home')
@section('breadcrumb1','Career')
@section('action-btn')
<a href="{{ route('add.career') }}" class="btn btn-sm btn-primary">Create</a>
@endsection
@section('content')
<div class="card">
    <form action="{{ route('career.list') }}" class="form" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body p-9">
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Careers Title</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="careers_title" value="{{ $settings['careers_title'] ?? '' }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Careers Subtitle</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="careers_subtitle" value="{{ $settings['careers_subtitle'] ?? '' }}" />
                </div>
            </div>
            <div class="row mb-8">
                <div class="col-xl-3">
                    <label class="required fs-6 fw-semibold mb-2">Careers Image</label>
                </div>
                <div class="col-lg-9">
                    <input type="file" class="form-control form-control-solid" name="careers_image" value="" />
                </div>
            </div>
            <div>
                <img src="{{ asset('assets/media/img/' . $settings['careers_image']) }}" style="width:100px; hegiht:50px">
                </div>
        </div>
        <div class="card-footer d-flex justify-content-end py-6 px-9">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
</div>
    <div class="card mt-5">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Title</th>
                    <th class="min-w-125px">Descriptions</th>
                    <th class="min-w-125px">Position</th>
                    <th class="text-end min-w-70px">Actions</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($ourjourney as $key => $list)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $list->profile}}</td>
                        <td>{{ $list->qualification}}</td>
                        <td>{!! Str::limit($list->profile_description, 100, '...') !!}</td>
                        <td class="text-end">
                                <a href="{{ route('career.edit',$list->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </a>

                                <a href="#" onclick="delete_this('{{route('career.delete',$list->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </a>
                        </td>
                       
                        
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
    </script>
@endpush
