@extends('layouts.dashboard')

@section('toolbar-heading', 'Career')
@section('breadcrumb', 'Home')
@section('breadcrumb1', 'Career')

@section('content')
<div class="card mt-5">
    <div class="card-header">
        <div class="card-title fs-3 fw-bold">Career</div>
    </div>
    <form id="kt_project_settings_form" action="{{ route('career.storecareer') }}" class="form" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body p-9">
            <div class="row mb-5" id="image-div">
                <div class="col-xl-2 mb-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">Profile</div>
                </div>
                <div class="col-xl-9 mb-3">
                    <input type="hidden" class="form-control form-control-solid" name="id" id="id" value="{{ $id ?? '' }}" />
                    <input type="text" class="form-control form-control-solid" name="profile" id="profile" value="{{ $profile ?? '' }}" />
                </div>
            </div>
            <div class="row mb-5" id="image-div">
                <div class="col-xl-2 mb-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">Qualification</div>
                </div>
                <div class="col-xl-9 mb-3">
                    <input type="text" class="form-control form-control-solid" name="qualification" id="qualification" value="{{ $qualification ?? '' }}" />
                </div>
            </div>
            <div class="row mb-5" id="image-div">
                <div class="col-xl-2 mb-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">Candidate</div>
                </div>
                <div class="col-xl-9 mb-3">
                    <input type="text" class="form-control form-control-solid" name="candidate" id="candidate" value="{{ $candidate ?? '' }}" />
                </div>
            </div>
            <div class="row mb-5" id="image-div">
                <div class="col-xl-2 mb-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">Location</div>
                </div>
                <div class="col-xl-9 mb-3">
                    <input type="text" class="form-control form-control-solid" name="location" id="location" value="{{ $location ?? '' }}" />
                </div>
            </div>
            <div class="row mb-5" id="image-div">
                <div class="col-xl-2 mb-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">No of Positions</div>
                </div>
                <div class="col-xl-9 mb-3">
                    <input type="number" class="form-control form-control-solid" name="no_of_positions" id="no_of_positions" value="{{ $no_of_positions ?? '' }}" />
                </div>
            </div>
            <div class="row mb-5" id="image-div">
                <div class="col-xl-2 mb-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3 required">Description</div>
                </div>
                <div class="col-xl-9 mb-3">
                    <textarea name="profile_description" id="profile_description" class="form-control form-control-solid h-300px tinymce">{{ $profile_description ?? '' }}</textarea>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-end py-6 px-9">
            <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Save</button>
        </div>
    </form>
</div>
@endsection

@push('java-script')

<script src="https://cdn.ckeditor.com/ckeditor5/37.0.1/classic/ckeditor.js"></script>

<script>
    ClassicEditor
        .create(document.querySelector('#profile_description'), {
            ckfinder: {
                uploadUrl: '{{ route('ckeditor.upload').'?_token='.csrf_token() }}',
            }
        })
        .catch(error => {
            console.error(error);
        });
</script>
@endpush
