@extends('layouts.dashboard')
@section('toolbar-heading','Enquires')
@section('breadcrumb','Home')
@section('breadcrumb1','Enquires')
@section('content')
    <div class="card">
        <div class="card-body pt-4">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="datatable">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th>#</th>
                    <th>Company Name</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Mobile No.</th>
                    <th>Country</th>
                    <th>Enquiry Type</th>
                    <th>Date</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($enquires as $key => $enquiry)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $enquiry->company_name }}</td>
                        <td>{{ $enquiry->name }}</td>
                        <td>{{ $enquiry->email }}</td>
                        <td>{{ $enquiry->mobile_no }}</td>
                        <td>{{ $enquiry->country }}</td>
                        <td>{{ $enquiry->enquiry_type }}</td>
                        <td>{{ $enquiry->created_at->format('d M, Y') }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#datatable').dataTable({
            order: [[0, 'desc']]
        })
    </script>
@endpush
