@extends('layouts.dashboard')
@section('toolbar-heading','FAQ Category')
@section('breadcrumb','Home')
@section('breadcrumb1','FAQ Category')
@section('action-btn')
@can('create_blog_category')
    <button onclick="modal('{{route('faq-category.create')}}')" class="btn btn-sm btn-primary">Create</button>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-4">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th>Name</th>
                    
                    @can('edit_blog_category')
                        <th>Status</th>
                    @endcan
                    <th>Faq</th>
                    @canany(['edit_blog_category','delete_blog_category'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($faqCategories as $faqCategory)
                    <tr>
                        <td>{{ $faqCategory->name }}</td>
                        
                        @can('edit_blog_category')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $faqCategory->id }}" {{ $faqCategory->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        <td><a href="{{route('faq-faqindex',$faqCategory->id)}}" class="btn btn-info btn-sm">ADD FAQ</a></td>
                        @canany(['edit_blog_category','delete_blog_category'])
                            <td class="text-end">
                                @can('edit_blog_category')
                                    <button type="button" onclick="modal('{{route('faq-category.edit',$faqCategory->id)}}')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </button>
                                @endcan
                                @can('delete_blog_category')
                                    <button type="button" onclick="delete_this('{{ route('faq-category.destroy',$faqCategory->id) }}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </button>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('faq-category-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });
    </script>
@endpush
