@extends('layouts.dashboard')
@section('toolbar-heading','Offices')
@section('breadcrumb','Home')
@section('breadcrumb1','Offices')
@section('action-btn')
@can('create_office')
    <a href="{{ route('office.create') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="datatable">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Office Image</th>
                    <th class="min-w-125px">Company Name</th>
                    <th class="min-w-125px">Trade ID</th>
                    <th class="min-w-125px">Country</th>
                    @can('edit_office')
                        <th class="min-w-125px">Status</th>
                    @endcan
                    @canany(['edit_office','delete_office'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($offices as $key => $office)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td><img src="{{ get_file('office', $office->image) }}" width="150px" height="150px" alt="Image" id="currentImage"></td>
                        <td>{{ $office->company_name }}</td>
                        <td>{{ $office->trade_id }}</td>
                        <td>{{ $office->country }}</td>
                        @can('edit_office')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $office->id }}" {{ $office->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        @canany(['edit_office','delete_office'])
                            <td class="text-end">
                                @can('edit_office')
                                    <a href="{{ route('office.edit',$office->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('delete_office')
                                    <a href="#" onclick="delete_this('{{route('office.destroy',$office->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.3/jquery-ui.min.js"></script>
    <script>
        $('#datatable').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('office-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });
    </script>
@endpush
