@extends('layouts.dashboard')
@section('toolbar-heading','Page Section')
@section('breadcrumb','Home')
@section('breadcrumb1','Page Section')
@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title fs-3 fw-bold">Edit Page Section</div>
        </div>
        <form id="kt_project_settings_form" action="{{ route('page-section.update',$pageSection->id) }}" class="form" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="card-body p-9">
                <div class="row mb-5" id="image-div">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Image</div>
                    </div>
                    <label class=" btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow remove-image-btn" id="remove-image" title="Remove image">
                            <i class="bi bi-x fs-4"></i>
                        </label>
                    <div class="col-lg-8">
                        <input type="hidden" name="id" id="id" value="{{ $pageSection->id }}" />
                        <div class="image-input image-input-outline image-input-empty" data-kt-image-input="true" style="">
                            <div class="image-input-wrapper w-125px h-125px bgi-position-center" style="background-image:url('{{ get_file('page-section',$pageSection->image) }}')" id="img-div"></div>
                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                                <i class="bi bi-pencil-fill fs-7"></i>
                                <input type="file" id="image" name="image" accept=".png, .jpg, .jpeg, .webp" />
                                <input type="hidden" name="image_remove" />
                            </label>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                        </div>
                        <div class="form-text">Allowed file types: png, jpg, jpeg, webp.</div>
                        <input type="hidden" name="content_image" id="content_image" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Image Position</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <select name="image_position" data-control="select2" class="form-select form-select-solid form-select-lg" id="image_position">
                            <option value="">Select Position</option>
                            <option value="Left" {{ $pageSection->image_position == 'Left' ? 'selected' : '' }}>Left</option>
                            <option value="Center" {{ $pageSection->image_position == 'Center' ? 'selected' : '' }} >Center (Full)</option>
                            <option value="Right" {{ $pageSection->image_position == 'Right' ? 'selected' : '' }}>Right</option>
                        </select>
                    </div>
                </div>
                <div class="row mb-5" id="image-div">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Background Image</div>
                    </div>
                    <label class=" btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow remove-image-btn" id="remove-bgimage" title="Remove image">
                            <i class="bi bi-x fs-4"></i>
                        </label>
                    <div class="col-lg-8">
                        <input type="hidden" name="id" id="id" value="{{ $pageSection->id }}" />
                        <div class="image-input image-input-outline image-input-empty" data-kt-image-input="true" style="">
                            <div class="image-input-wrapper w-125px h-125px bgi-position-center" style="background-image:url('{{ get_file('page-section',$pageSection->bg_image) }}')" id="bgimg-div"></div>
                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                                <i class="bi bi-pencil-fill fs-7"></i>
                                <input type="file" id="image" name="bg_image" accept=".png, .jpg, .jpeg, .webp" />
                                <input type="hidden" name="image_remove" />
                            </label>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove image">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                        </div>
                        <div class="form-text">Allowed file types: png, jpg, jpeg, webp.</div>
                        <input type="hidden" name="content_image" id="content_image" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Name</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <input type="text" class="form-control form-control-solid" name="name" id="name" value="{{ $pageSection->name }}" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Content</div>
                    </div>
                    <div class="col-xl-9 fv-row">
                        <textarea name="description" id="description" class="form-control form-control-solid h-300px tinymce">{{$pageSection->description}}</textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Status</div>
                    </div>
                    <div class="col-xl-9">
                        <div class="form-check form-switch form-check-custom form-check-solid">
                            <input class="form-check-input" type="checkbox" id="status" name="status" {{ $pageSection->status ? 'checked' : '' }} />
                            <label class="form-check-label fw-semibold text-gray-400 ms-3" for="status"></label>
                        </div>
                    </div>
                </div>
                 
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Save</button>
            </div>
        </form>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    $('#remove-image').click(function() {
       
        if (confirm('Are you sure you want to remove the image?')) {
            $.ajax({
                url: '{{ route('removesection.image') }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}', // CSRF token
                    id: '{{ $pageSection->id }}' // User ID
                },
                success: function(response) {
                    if (response.success) {
                        $('#img-div').css('background-image', 'none'); // Clear the image
                        alert(response.message);
                    } else {
                        alert(response.message);
                    }
                },
                error: function(xhr) {
                    $('#img-div').css('background-image', 'none'); // Clear the image on error
                    alert('An error occurred while removing  image.');
                }
            });
        }
    });
});
$(document).ready(function() {
    $('#remove-bgimage').click(function() {
       
        if (confirm('Are you sure you want to remove the image?')) {
            $.ajax({
                url: '{{ route('removesection.bgimage') }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}', // CSRF token
                    id: '{{ $pageSection->id }}' // User ID
                },
                success: function(response) {
                    if (response.success) {
                        $('#bgimg-div').css('background-image', 'none'); // Clear the image
                        alert(response.message);
                    } else {
                        alert(response.message);
                    }
                },
                error: function(xhr) {
                    $('#bgimg-div').css('background-image', 'none'); // Clear the image on error
                    alert('An error occurred while removing  image.');
                }
            });
        }
    });
});
</script>
    </div>
    @if($pageSection->slug == 'our-journey')
     <div class="card mt-5">
    <a href="{{ route('add.manage_ourjourney') }}" class="btn btn-sm btn-primary m-3 float-end" style="width:75px">Create</a> 
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Year</th>
                    <th class="min-w-125px">Descriptions</th>
                    <th class="min-w-125px">Images</th>
                    <th class="text-end min-w-70px">Actions</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($ourjourney as $key => $list)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $list->year }}</td>
                        <td>{{ $list->descriptions }}</td>
                        <td>{{ $list->images }}</td>
                        <td class="text-end">
                                <a href="{{ route('edit.manage_ourjourney',$list->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </a>

                                <a href="#" onclick="delete_this('{{route('deleteOurjourney',$list->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
@endsection
@push('java-script')
<script>
        $('#kt_users_table').dataTable();

    </script>

 <script src="https://cdn.ckeditor.com/ckeditor5/37.0.1/super-build/ckeditor.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        ckeditor5_init();
    });

    function ckeditor5_init() {
        CKEDITOR.ClassicEditor.create(document.querySelector('#description'), {
            ckfinder: {
                uploadUrl: '{{ route('ckeditor.upload').'?_token='.csrf_token() }}',
            },
            toolbar: {
                items: [
                    'exportPDF', 'exportWord', '|',
                    'findAndReplace', 'selectAll', '|',
                    'heading', '|',
                    'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
                    'bulletedList', 'numberedList', 'todoList', '|',
                    'outdent', 'indent', '|',
                    'undo', 'redo',
                    '-',
                    'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
                    'alignment', '|',
                    'link', 'insertImage', 'blockQuote', 'insertTable', 'mediaEmbed', 'codeBlock', 'htmlEmbed', '|',
                    'specialCharacters', 'horizontalLine', 'pageBreak', '|',
                    'textPartLanguage', '|',
                    'sourceEditing'
                ],
                shouldNotGroupWhenFull: true
            },
            list: {
                properties: {
                    styles: true,
                    startIndex: true,
                    reversed: true
                }
            },
            heading: {
                options: [
                    { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                    { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                    { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                    { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
                    { model: 'heading4', view: 'h4', title: 'Heading 4', class: 'ck-heading_heading4' },
                    { model: 'heading5', view: 'h5', title: 'Heading 5', class: 'ck-heading_heading5' },
                    { model: 'heading6', view: 'h6', title: 'Heading 6', class: 'ck-heading_heading6' }
                ]
            },
            placeholder: 'Welcome to CKEditor 5!',
            fontFamily: {
                options: [
                    'default',
                    'Arial, Helvetica, sans-serif',
                    'Courier New, Courier, monospace',
                    'Georgia, serif',
                    'Lucida Sans Unicode, Lucida Grande, sans-serif',
                    'Tahoma, Geneva, sans-serif',
                    'Times New Roman, Times, serif',
                    'Trebuchet MS, Helvetica, sans-serif',
                    'Verdana, Geneva, sans-serif'
                ],
                supportAllValues: true
            },
            fontSize: {
                options: [10, 12, 14, 'default', 18, 20, 22],
                supportAllValues: true
            },
            htmlSupport: {
                allow: [
                    {
                        name: /.*/,
                        attributes: true,
                        classes: true,
                        styles: true
                    }
                ]
            },
            htmlEmbed: {
                showPreviews: true
            },
            link: {
                decorators: {
                    addTargetToExternalLinks: true,
                    defaultProtocol: 'https://',
                    toggleDownloadable: {
                        mode: 'manual',
                        label: 'Downloadable',
                        attributes: {
                            download: 'file'
                        }
                    }
                }
            },
            mention: {
                feeds: [
                    {
                        marker: '@',
                        feed: [
                            '@apple', '@bears', '@brownie', '@cake', '@cake', '@candy', '@canes', '@chocolate', '@cookie', '@cotton', '@cream',
                            '@cupcake', '@danish', '@donut', '@dragée', '@fruitcake', '@gingerbread', '@gummi', '@ice', '@jelly-o',
                            '@liquorice', '@macaroon', '@marzipan', '@oat', '@pie', '@plum', '@pudding', '@sesame', '@snaps', '@soufflé',
                            '@sugar', '@sweet', '@topping', '@wafer'
                        ],
                        minimumCharacters: 1
                    }
                ]
            },
            removePlugins: [
                'CKBox',
                'CKFinder',
                'EasyImage',
                'RealTimeCollaborativeComments',
                'RealTimeCollaborativeTrackChanges',
                'RealTimeCollaborativeRevisionHistory',
                'PresenceList',
                'Comments',
                'TrackChanges',
                'TrackChangesData',
                'RevisionHistory',
                'Pagination',
                'WProofreader',
                'MathType'
            ]
        });
    }
</script>
@endpush
