@extends('layouts.dashboard')
@section('toolbar-heading','Page Section')
@section('breadcrumb','Home')
@section('breadcrumb1','Page Section')
@section('action-btn')
@can('create_page_section')
    <a href="{{ route('page-section.create') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Name</th>
                    <th class="min-w-125px">Slug</th>
                    @can('edit_page_section')
                        <th class="min-w-125px">Status</th>
                    @endcan
                    @canany(['edit_page_section','delete_page_section'])
                        <th class="text-end min-w-70px">Actions</th>
                    @endcanany
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($pageSections as $key => $pageSection)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $pageSection->name }}</td>
                        <td>{{ $pageSection->slug }}</td>
                        @can('edit_page_section')
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="{{ $pageSection->id }}" {{ $pageSection->status ? 'checked' : '' }}>
                                </div>
                            </td>
                        @endcan
                        @canany(['edit_page_section','delete_page_section'])
                            <td class="text-end">
                                @can('edit_page_section')
                                    <a href="{{ route('page-section.edit',$pageSection->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                                @can('delete_page_section')
                                    <a href="#" onclick="delete_this('{{route('page-section.destroy',$pageSection->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                @endcan
                            </td>
                        @endcanany
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '{{ route('page-section-status') }}',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','{{ __('Something went wrong') }}');
                }
            });
        });
    </script>
@endpush
