@extends('layouts.dashboard')
@section('toolbar-heading','Our Journey')
@section('breadcrumb','Home')
@section('breadcrumb1','Our Journey')
@section('action-btn')
@can('create_page_section')
    <a href="{{ route('add.manage_ourjourney') }}" class="btn btn-sm btn-primary">Create</a>
@endcan
@endsection
@section('content')
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Year</th>
                    <th class="min-w-125px">Descriptions</th>
                    <th class="min-w-125px">Images</th>
                    <th class="text-end min-w-70px">Actions</th>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                @foreach($ourjourney as $key => $list)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $list->year }}</td>
                        <td>{!! $list->descriptions !!}</td>
                        <td> <img src="{{ get_file('page-section',$list->images ?? '') }}" style="height:75px; width:75px;"></td>
                        <td class="text-end">
                                <a href="{{ route('edit.manage_ourjourney',$list->id) }}" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-pencil-fill fs-7"></i>
                                    </span>
                                </a>

                                <a href="#" onclick="delete_this('{{route('deleteOurjourney',$list->id)}}','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                    <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                        <i class="bi bi-trash3 fs-7"></i>
                                    </span>
                                </a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@push('java-script')
    <script>
        $('#kt_users_table').dataTable();
    </script>
@endpush
