@extends('layouts.dashboard')
@section('toolbar-heading','Edit Role')
@section('breadcrumb','Home')
@section('breadcrumb1','Edit Role')
@section('content')
    <div class="card">
        <form  action="{{ route('role.update',$role->id) }}" class="form" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="card-body p-9">
                <div class="row g-9 mb-8">
                    <div class="col-md-12 fv-row">
                        <label class="required fs-6 fw-semibold mb-2">Name</label>
                        <input type="text" class="form-control form-control-solid" placeholder="Enter Role name" name="name" value="{{ $role->name }}">
                    </div>
                    <div class="col-md-12">
                        <label class="required fs-6 fw-semibold mb-4">Permissions</label>
                        <div class="row">
                            @foreach($permissions as $groupName => $permissionGroup)
                                <div class="col-12 py-4">
                                    <span class="bullet bullet-dot bg-info me-2 h-10px w-10px"></span>
                                    <span class="fw-bold text-gray-600 fs-6">{{ $groupName }}</span>
                                </div>
                                @foreach($permissionGroup as $permission)
                                    <div class="col-md-3 align-items-center mb-3">
                                        <label class="form-check form-check-custom form-check-solid">
                                            <input class="form-check-input h-20px w-20px permission" type="checkbox" name="permissions[]" value="{{$permission->id}}" {{ in_array($permission->id,$selected_permissions) ? 'checked' : ''}}>
                                            <span class="form-check-label fw-semibold">{{ ucwords(str_replace('_',' ',$permission->name)) }}</span>
                                        </label>
                                    </div>
                                @endforeach
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Update</button>
            </div>
        </form>
    </div>
@endsection
