@extends('layouts.dashboard')
@section('toolbar-heading','Menu Settings')
@section('breadcrumb','Home')
@section('breadcrumb1','Menu Settings')
@section('content')
<div class="card">
    <div class="card-body p-9">
        <form action="{{ route('settings.menuUpdate', $menuItem->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row mb-3">
                <div class="col-xl-3">
                    <label for="title" class="fs-6 fw-semibold mb-2">Title</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="title" id="title" value="{{ $menuItem->title }}">
                    @error('title')<span class="text-danger">{{ $message }}</span> @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-xl-3">
                    <label for="url" class="fs-6 fw-semibold mb-2">URL</label>
                </div>
                <div class="col-lg-9">
                    <input type="text" class="form-control form-control-solid" name="url" id="url" value="{{ $menuItem->url }}">
                    @error('url')<span class="text-danger">{{ $message }}</span> @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-xl-3">
                    <label for="parent_id" class="fs-6 fw-semibold mb-2">Parent</label>
                </div>
                <div class="col-lg-9">
                    <select data-control="select2" data-hide-search="false" class="form-select form-select-solid select2-m" name="parent_id" id="parent_id">
                        <option value="">None</option>
                        @foreach ($menuItems as $item)
                            <option value="{{ $item->id }}" @if($item->id == $menuItem->parent_id) selected @endif>{{ $item->title }}</option>
                        @endforeach
                    </select>
                    @error('parent_id')<span class="text-danger">{{ $message }}</span> @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-xl-3">
                    <label for="order" class="fs-6 fw-semibold mb-2">Order</label>
                </div>
                <div class="col-lg-9">
                    <input type="number" class="form-control form-control-solid" name="order" id="order" value="{{ $menuItem->order }}">
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-xl-3">
                    <label for="image" class="fs-6 fw-semibold mb-2">Image</label>
                </div>
                <div class="col-lg-9">
                    <input type="file" class="form-control form-control-solid" id="image" name="image" accept=".png, .jpg, .jpeg, .webp" />
                    <div>
                        <img src="{{ get_file('manu-section', $menuItem->image) }}" width="150px" height="150px" alt="Image" id="currentImage">
                    </div>
                    <div>
                        <img src="" class="d-none" id="imagePreview" width="150px" height="150px" alt="Image">
                    </div>
                </div>
            </div>
            <div class="row mb-3">
             <div class="col-md-6 fv-row">
                <label class=" fs-6 fw-semibold mb-2">Meta Title</label>
                <input type="text" class="form-control form-control-solid" name="metatitle" value="{{ $menuItem->metatitle }}">
                
            </div>
             <div class="col-md-6 fv-row">
                <label class=" fs-6 fw-semibold mb-2">Meta Keyword</label>
                <input class="form-control form-control-solid" name="metakeyword" value="{{ $menuItem->metakeyword }}" id="kt_tagify_1"/>
                <!--<input type="text" class="form-control " name="metakeyword" >-->
            </div>
            <div class="col-md-12 fv-row">
                <label class="fs-6 fw-semibold mb-2">Meta Description</label>
                <textarea name="metadescription" id="metadescription" class="form-control form-control-solid">{{ $menuItem->metadescription }}</textarea>
            </div>
            </div>


            <div class="row mb-3">
                <div class="col-xl-3"></div>
                <div class="col-lg-9">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </div>
        </form>
</div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('#image').on('change', function(e) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).removeClass('d-none');
            $('#currentImage').addClass('d-none'); // Hide the current image when a new one is selected
        }
        reader.readAsDataURL(this.files[0]);
    });
});
</script>

@endsection
