@extends('layouts.dashboard')
@section('toolbar-heading','Sitemap')
@section('breadcrumb','Sitemap')
@section('content')
{{--<div class="container py-4">
    <h2 class="mb-4">Generate Sitemap</h2>

    @if(session('success'))
        <div class="alert alert-success">
            {!! session('success') !!}
        </div>
    @endif

    <form method="POST" action="{{ route('sitemap.generate') }}">
        @csrf
        <button class="btn btn-primary">
            ⚙️ Generate Sitemap
        </button>
    </form>

    <hr>
    <p class="mt-3">
        <strong>Current Sitemap:</strong><br>
        @if(file_exists(base_path('../sitemap.xml')))
            <a href="https://elevatebpm.com/sitemap.xml" target="_blank">https://elevatebpm.com/sitemap.xml</a>
        @else
            <em>No sitemap generated yet.</em>
        @endif
    </p>
</div>--}}

<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            {{-- ✅ Page Title --}}
            <div class="text-center mb-4">
                <h2 class="fw-bold text-primary">
                    🌐 Sitemap & Robots Manager
                </h2>
                <p class="text-muted">Manage your website’s sitemap and robots.txt file easily.</p>
            </div>

            {{-- ✅ Success Message --}}
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
                    {!! session('success') !!}
                    <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">&times;</button>
                </div>
            @endif

            {{-- ⚙️ Generate Sitemap --}}
            <div class="card shadow-sm mb-4 border-0 rounded-3">
                <div class="card-body">
                    <h5 class="card-title mb-3">
                        ⚙️ Generate Sitemap
                    </h5>
                    <p class="text-muted mb-3">Click below to generate or refresh your sitemap.xml file.</p>

                    <form method="POST" action="{{ route('sitemap.generate') }}">
                        @csrf
                        <button class="btn btn-primary px-4">
                            <i class="fas fa-sync-alt me-1"></i> Generate Sitemap
                        </button>
                    </form>

                    <hr class="my-4">
                    <p class="mb-0">
                        <strong>Current Sitemap:</strong><br>
                        @if(file_exists(base_path('../sitemap.xml')))
                            <a href="https://elevatebpm.com/sitemap.xml" target="_blank" class="text-decoration-none">
                                🌍 https://elevatebpm.com/sitemap.xml
                            </a>
                        @else
                            <em class="text-muted">No sitemap generated yet.</em>
                        @endif
                    </p>
                </div>
            </div>

            {{-- 🤖 Upload robots.txt --}}
            <div class="card shadow-sm border-0 rounded-3">
                <div class="card-body">
                    <h5 class="card-title mb-3">
                        🤖 Upload robots.txt
                    </h5>
                    <p class="text-muted mb-3">Upload a new <code>robots.txt</code> file. Existing one will be replaced automatically.</p>

                    <form method="POST" action="{{ route('robots.upload') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="mb-3">
                            <input type="file" name="robots_file" class="form-control" accept=".txt" required>
                        </div>
                        <button class="btn btn-success px-4">
                            <i class="fas fa-upload me-1"></i> Upload robots.txt
                        </button>
                    </form>

                    <hr class="my-4">
                    <p class="mb-0">
                        <strong>Current robots.txt:</strong><br>
                        @if(file_exists(base_path('../robots.txt')))
                            <a href="https://elevatebpm.com/robots.txt" target="_blank" class="text-decoration-none">
                                📄 https://elevatebpm.com/robots.txt
                            </a>
                        @else
                            <em class="text-muted">No robots.txt uploaded yet.</em>
                        @endif
                    </p>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection
@push('java-script')

@endpush
