@extends('layouts.dashboard')
@section('toolbar-heading','Edit Staff')
<meta name="csrf-token" content="{{ csrf_token() }}">
@section('breadcrumb','Home')
@section('breadcrumb1','Edit Staff')
@section('content')
<div class="card">
    <form  action="{{ route('users.update',$user->id) }}" class="form" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="card-body p-9">
            <div class="row mb-5">
                <div class="col-xl-3">
                    <div class="fs-6 fw-semibold mt-2 mb-3">Image</div>
                </div>
                <label class=" btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow remove-image-btn" id="remove-image" title="Remove image">
                            <i class="bi bi-x fs-4"></i>
                        </label>
                <div class="col-lg-8">
                       
                    <div class="image-input image-input-outline image-input-empty" data-kt-image-input="true" id="img-div" style="background-image: url('{{ user_profile($user->profile) }}')">
                        
                        <div class="image-input-wrapper w-125px h-125px bgi-position-center" style="" id="img-div"></div>
                        
                        <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                            <i class="bi bi-pencil-fill fs-7"></i>
                            <input type="file" id="image" name="image" accept=".png, .jpg, .jpeg" />
                            <input type="hidden" name="image_remove" />
                        </label>
                        <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel image">
                            <i class="bi bi-x fs-2"></i>
                        </span>
                        <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-white shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove image">
                            <i class="bi bi-x fs-2"></i>
                        </span>
                        
                    </div>
                    
                    <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Name</div>
                    </div>
                    <div class="col-xl-8 fv-row">
                        <input type="text" class="form-control form-control-solid" name="name" value="{{ $user->name }}" id="name" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Email</div>
                    </div>
                    <div class="col-xl-8 fv-row">
                        <input type="email" class="form-control form-control-solid" name="email" value="{{ $user->email }}" id="email" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3">Phone Number</div>
                    </div>
                    <div class="col-xl-8 fv-row">
                        <input type="number" data-limit="10" class="form-control form-control-solid" name="phone_no" value="{{ $user->phone_no }}" id="phone_no" />
                    </div>
                </div>
                <div class="row mb-8">
                    <div class="col-xl-3">
                        <div class="fs-6 fw-semibold mt-2 mb-3 required">Role</div>
                    </div>
                    <div class="col-xl-8 fv-row">
                        <select name="role" data-control="select2" data-hide-search="true" data-placeholder="Select a Role..." class="form-select form-select-solid">
                            <option value="">Select a Role...</option>
                            @foreach($roles as $role)
                                <option value="{{ $role->id }}" {{ $role->id == $user->roles()->first()->id ? 'selected' : '' }}>{{ $role->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="submit" class="btn btn-primary" id="kt_project_settings_submit">Save</button>
            </div>
        </div>
        
    </form>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    $('#remove-image').click(function() {
       
        if (confirm('Are you sure you want to remove the image?')) {
            $.ajax({
                url: '{{ route('remove.image') }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}', // CSRF token
                    user_id: '{{ $user->id }}' // User ID
                },
                success: function(response) {
                    if (response.success) {
                        $('#img-div').css('background-image', 'none'); // Clear the image
                        alert(response.message);
                    } else {
                        alert(response.message);
                    }
                },
                error: function(xhr) {
                    $('#img-div').css('background-image', 'none'); // Clear the image on error
                    alert('An error occurred while removing the image.');
                }
            });
        }
    });
});
</script>
</div>
@endsection
