<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\FaqCategoryController;
use App\Http\Controllers\Api\FaqController;
use App\Http\Controllers\Api\SiteController;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\StaffController;
use App\Http\Controllers\Api\RoleController;
use App\Http\Controllers\Api\BlogController;
use App\Http\Controllers\Api\PagesController;
use App\Http\Controllers\Api\TeamMembersController;
use App\Http\Controllers\Api\PartnersController;
use App\Http\Controllers\Api\PageSectionController;
use App\Http\Controllers\Api\CareerController;
use App\Http\Controllers\Api\MenuSettingsController;
use App\Http\Controllers\Api\HeroController;
use App\Http\Controllers\Api\OfficesController;
use App\Http\Controllers\Api\SettingsController;
use App\Http\Controllers\Api\UsersController;
use App\Http\Controllers\Api\AboutUsController;
use App\Http\Controllers\Api\GlobalReachController;
use App\Http\Controllers\Api\TestimonialController;
use App\Http\Controllers\MenuController;


//v2 routes
use App\Http\Controllers\Api\v2\BlogController as StageBlogController;
use App\Http\Controllers\Api\v2\PagesController as StagePagesController;
use App\Http\Controllers\Api\v2\PartnersController as StagePartnersController;
use App\Http\Controllers\Api\v2\CareerController as StageCareerController;
use App\Http\Controllers\Api\v2\StaffController as StageStaffController;
use App\Http\Controllers\Api\v2\PageSectionController as StagePageSectionController;
use App\Http\Controllers\Api\v2\MenuSettingsController as StageMenuSettingsController;
use App\Http\Controllers\Api\v2\SiteController as StageSiteController;
use App\Http\Controllers\Api\v2\HeroController as StageHeroController;
use App\Http\Controllers\Api\v2\OfficesController as StageOfficesController;
use App\Http\Controllers\Api\v2\FaqController as StageFaqController;
use App\Http\Controllers\Api\v2\FaqCategoryController as StageFaqCategoryController;
use App\Http\Controllers\Api\v2\GlobalReachController as StageGlobalReachController;
use App\Http\Controllers\Api\v2\TestimonialController as StageTestimonialController;
use App\Http\Controllers\Api\v2\TeamMembersController as StageTeamMembersController;
use App\Http\Controllers\Api\v2\ApiController as StageApiController;





/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('get-data', [SiteController::class, 'settings']);
Route::get('get-blog-categories', [SiteController::class, 'blogCategory']);
Route::get('get-blogs', [SiteController::class, 'blogs']);
Route::post('contact-us', [SiteController::class, 'contactUs']);
Route::get('get-hero-section', [SiteController::class, 'heroSection']);
Route::get('get-menu', [SiteController::class, 'getMenuBySlug']);
Route::get('get-page-section', [SiteController::class, 'getSectionBySlug']);
Route::post('enquires', [SiteController::class, 'enquires']);
Route::post('getIntouch', [SiteController::class, 'getIntouch']);
Route::post('resume', [SiteController::class, 'resume']);

Route::post('homePage', [ApiController::class, 'homePage']);
Route::post('getFooter', [ApiController::class, 'getFooter']);


// faq category
Route::post('faqCategoryList', [FaqCategoryController::class, 'faqCategoryList']);
Route::post('storeFaqCategory', [FaqCategoryController::class, 'storeFaqCategory']);
Route::post('updateFaqCategory', [FaqCategoryController::class, 'updateFaqCategory']);
Route::post('deleteFaqCategory', [FaqCategoryController::class, 'deleteFaqCategory']);
Route::get('faq-category-status', [FaqCategoryController::class, 'updateStatus'])->name('faq-category-status');

// faq
Route::post('faqList', [FaqController::class, 'faqList']);
Route::post('storeFaq', [FaqController::class, 'storeFaq']);
Route::post('updateFaq', [FaqController::class, 'updateFaq']);
Route::post('deleteFaq', [FaqController::class, 'deleteFaq']);
Route::get('faq-status', [FaqController::class, 'updateStatus'])->name('faq-status');

//menu
Route::get('getAllMenus', [ApiController::class, 'getAllMenus']);
Route::post('createMenu', [ApiController::class, 'createMenu']);
Route::post('updateMenu', [ApiController::class, 'updateMenu']);
Route::post('deleteMenu', [ApiController::class, 'deleteMenu']);




//offices
Route::get('getAllOffices', [ApiController::class, 'getAllOffices']);
Route::get('getOfficeById', [ApiController::class, 'getOfficeById']);
Route::get('getteammemberById', [ApiController::class, 'getteammemberById']);
Route::get('getblogdetailsById', [ApiController::class, 'getblogdetailsById']);
Route::post('createGetintuch', [ApiController::class, 'createGetintuch']);
Route::post('submitResume', [ApiController::class, 'submitResume']);

Route::post('adminLogin', [ApiController::class, 'adminLogin']);



//Role
Route::post('getAllPermission', [RoleController::class, 'getAllPermission']);
Route::post('getAllrole', [RoleController::class, 'getAllrole']);
Route::post('storeRole', [RoleController::class, 'storeRole']);
Route::post('updateRole', [RoleController::class, 'updateRole']);
Route::post('deleteRole', [RoleController::class, 'deleteRole']);

//Staff
Route::post('createStaff', [StaffController::class, 'createStaff']);
Route::post('updateStaff', [StaffController::class, 'updateStaff']);
Route::post('deleteStaff', [StaffController::class, 'deleteStaff']);
Route::post('staffList', [StaffController::class, 'staffList']);

//BlogsCategory
Route::post('blogCategoryList', [BlogController::class, 'blogCategoryList']);
Route::post('storeBlogCategory', [BlogController::class, 'storeBlogCategory']);
Route::post('updateBlogCategory', [BlogController::class, 'updateBlogCategory']);
Route::post('deleteBlogCategory', [BlogController::class, 'deleteBlogCategory']);

//Blogs
Route::post('blogList', [BlogController::class, 'blogList']);
Route::post('storeBlog', [BlogController::class, 'storeBlog']);
Route::post('updateBlog', [BlogController::class, 'updateBlog']);
Route::post('deleteBlog', [BlogController::class, 'deleteBlog']);

//Pages
Route::post('pagesList', [PagesController::class, 'pagesList']);
Route::post('storePage', [PagesController::class, 'storePage']);
Route::post('updatePage', [PagesController::class, 'updatePage']);
Route::post('deletePage', [PagesController::class, 'deletePage']);

//TeamMember
Route::post('teamMembersList', [TeamMembersController::class, 'teamMembersList']);
Route::post('storeTeamMember', [TeamMembersController::class, 'storeTeamMember']);
Route::post('updateTeamMember', [TeamMembersController::class, 'updateTeamMember']);
Route::post('deleteTeamMember', [TeamMembersController::class, 'deleteTeamMember']);

//Partners
Route::post('partnersList', [PartnersController::class, 'partnersList']);
Route::post('storePartners', [PartnersController::class, 'storePartners']);
Route::post('updatePartners', [PartnersController::class, 'updatePartners']);
Route::post('deletePartners', [PartnersController::class, 'deletePartners']);

//TeamMember
Route::post('pageSectionList', [PageSectionController::class, 'pageSectionList']);
Route::post('storePageSection', [PageSectionController::class, 'storePageSection']);
Route::post('updatePageSection', [PageSectionController::class, 'updatePageSection']);
Route::post('deletePageSection', [PageSectionController::class, 'deletePageSection']);

//Our journey
Route::post('ourjourneyList', [PageSectionController::class, 'ourjourneyList']);
Route::post('storeOurjourney', [PageSectionController::class, 'storeOurjourney']);
Route::post('updateOurjourney', [PageSectionController::class, 'updateOurjourney']);
Route::post('deleteOurjourney', [PageSectionController::class, 'deleteOurjourney']);

//Career
Route::post('ourCareerList', [CareerController::class, 'ourCareerList']);
Route::post('storeCareer', [CareerController::class, 'storeCareer']);
Route::post('updateCareer', [CareerController::class, 'updateCareer']);
Route::post('deleteCareer', [CareerController::class, 'deleteCareer']);

//MenuSettings
Route::post('keyOffering', [MenuSettingsController::class, 'keyOffering']);
Route::post('keyOfferingdetails', [MenuSettingsController::class, 'keyOfferingdetails']);
Route::post('menuList', [MenuSettingsController::class, 'menuList']);
Route::post('storeMenu', [MenuSettingsController::class, 'storeMenu']);
Route::post('updateMenu', [MenuSettingsController::class, 'updateMenu']);
Route::post('deleteMenu', [MenuSettingsController::class, 'deleteMenu']);

//Hero Section
Route::post('heroSectionList', [HeroController::class, 'heroSectionList']);
Route::post('storeHeroSection', [HeroController::class, 'storeHeroSection']);
Route::post('updateHeroSection', [HeroController::class, 'updateHeroSection']);
Route::post('deleteHeroSection', [HeroController::class, 'deleteHeroSection']);

//Offices
Route::post('OfficesList', [OfficesController::class, 'OfficesList']);
Route::post('storeOffices', [OfficesController::class, 'storeOffices']);
Route::post('updateOffices', [OfficesController::class, 'updateOffices']);
Route::post('deleteOffices', [OfficesController::class, 'deleteOffices']);

//Settings
Route::get('getAllsettings', [SettingsController::class, 'getAllsettings']);
Route::post('siteSettings', [SettingsController::class, 'siteSettings']);

//User
Route::post('resetPassword', [UsersController::class, 'resetPassword']);
Route::post('updateProfile', [UsersController::class, 'updateProfile']);
Route::post('updateEmail', [UsersController::class, 'updateEmail']);
Route::post('changePassword', [UsersController::class, 'changePassword']);

// About Us
Route::post('about_us_list', [AboutUsController::class, 'about_us_list']);
Route::post('storeAboutus', [AboutUsController::class, 'storeAboutus']);


//Global Reach
Route::post('globalReachList', [GlobalReachController::class, 'globalReachList']);
Route::post('storeglobalReach', [GlobalReachController::class, 'storeglobalReach']);
Route::post('updateglobalReach', [GlobalReachController::class, 'updateglobalReach']);
Route::post('deleteglobalReach', [GlobalReachController::class, 'deleteglobalReach']);

//Testimonial
Route::post('testimonial', [TestimonialController::class, 'testimonial']);
Route::post('testimonialList', [TestimonialController::class, 'testimonialList']);
Route::post('storeTestimonial', [TestimonialController::class, 'storeTestimonial']);
Route::post('updateTestimonial', [TestimonialController::class, 'updateTestimonial']);
Route::post('deleteTestimonial', [TestimonialController::class, 'deleteTestimonial']);

Route::prefix('v2')->controller(SettingsController::class)->group(function () {
Route::get('getAllsettings', 'getAllsettings');

});

Route::prefix('v2')->controller(ApiController::class)->group(function () {
Route::get('getblogdetailsById', 'getblogdetailsById');

});

Route::prefix('v2')->controller(SiteController::class)->group(function () {
Route::get('get-blog-categories', 'blogCategory');
Route::get('get-blogs', 'blogs');
Route::post('contact-us', 'contactUs');
});

Route::prefix('v2')->controller(StageSiteController::class)->group(function () {
Route::get('get-blogs-v2', 'blogsv2');
});
Route::prefix('v2')->controller(StageBlogController::class)->group(function () {
    Route::post('blogList', 'blogList');
    Route::post('storeBlog', 'storeBlog');
    Route::post('updateBlog', 'updateBlog');
    Route::post('deleteBlog', 'deleteBlog');
    Route::post('blogCategoryList', 'blogCategoryList');
    Route::post('storeBlogCategory', 'storeBlogCategory');
    Route::post('updateBlogCategory', 'updateBlogCategory');
    Route::post('deleteBlogCategory', 'deleteBlogCategory');
});

Route::prefix('v2')->controller(StagePagesController::class)->group(function () {
    Route::post('pagesList', 'pagesList');
    Route::post('storePage', 'storePage');
    Route::post('updatePage', 'updatePage');
    Route::post('deletePage', 'deletePage');
});

Route::prefix('v2')->controller(StagePartnersController::class)->group(function () {
    Route::post('partnersList', 'partnersList');
    Route::post('storePartners', 'storePartners');
    Route::post('updatePartners', 'updatePartners');
    Route::post('deletePartners', 'deletePartners');
});

Route::prefix('v2')->controller(StageCareerController::class)->group(function () {
    Route::post('ourCareerList', 'ourCareerList');
    Route::post('storeCareer', 'storeCareer');
    Route::post('updateCareer', 'updateCareer');
    Route::post('deleteCareer', 'deleteCareer');
});


Route::prefix('v2')->controller(StageStaffController::class)->group(function () {
    Route::post('staffList', 'staffList');
    Route::post('createStaff', 'createStaff');
    Route::post('updateStaff', 'updateStaff');
    Route::post('deleteStaff', 'deleteStaff');
});

Route::prefix('v2')->controller(StagePageSectionController::class)->group(function () {
    Route::post('pageSectionList', 'pageSectionList');
    Route::post('storePageSection', 'storePageSection');
    Route::post('updatePageSection', 'updatePageSection');
    Route::post('deletePageSection', 'deletePageSection');
});

Route::prefix('v2')->controller(StagePageSectionController::class)->group(function () {
    Route::post('ourjourneyList', 'ourjourneyList');
    Route::post('storeOurjourney', 'storeOurjourney');
    Route::post('updateOurjourney', 'updateOurjourney');
    Route::post('deleteOurjourney', 'deleteOurjourney');
});

Route::prefix('v2')->controller(StageMenuSettingsController::class)->group(function () {
    Route::post('menuList', 'menuList');
    Route::post('storeMenu', 'storeMenu');
    Route::post('updateMenu', 'updateMenu');
    Route::post('deleteMenu', 'deleteMenu');
    Route::post('keyOffering', 'keyOffering');
    Route::post('keyOfferingdetails', 'keyOfferingdetails');
});


Route::prefix('v2')->controller(StageSiteController::class)->group(function () {
    Route::post('settings', 'settings');
    Route::post('blogCategory', 'blogCategory');
    Route::post('blogs', 'blogs');
    Route::post('contactUs', 'contactUs');
    Route::post('heroSection', 'heroSection');
    Route::post('getMenuBySlug', 'getMenuBySlug');
    Route::get('get-page-section', 'getSectionBySlug');
    Route::post('getAllMenus', 'getAllMenus');
    Route::post('enquires', 'enquires');
    Route::post('getIntouch', 'getIntouch');
    Route::post('resume', 'resume');
});


Route::prefix('v2')->controller(StageHeroController::class)->group(function () {
    Route::post('heroSectionList', 'heroSectionList');
    Route::post('storeHeroSection', 'storeHeroSection');
    Route::post('updateHeroSection', 'updateHeroSection');
    Route::post('deleteHeroSection', 'deleteHeroSection');
});

Route::prefix('v2')->controller(StageOfficesController::class)->group(function () {
    Route::post('OfficesList', 'OfficesList');
    Route::post('storeOffices', 'storeOffices');
    Route::post('updateOffices', 'updateOffices');
    Route::post('deleteOffices', 'deleteOffices');
});

Route::prefix('v2')->controller(StageFaqController::class)->group(function () {
    Route::post('faqList', 'faqList');
    Route::post('storeFaq', 'storeFaq');
    Route::post('updateFaq', 'updateFaq');
    Route::post('deleteFaq', 'deleteFaq');
});

Route::prefix('v2')->controller(StageFaqCategoryController::class)->group(function () {
    Route::post('faqCategoryList', 'faqCategoryList');
    Route::post('storeFaqCategory', 'storeFaqCategory');
    Route::post('updateFaqCategory', 'updateFaqCategory');
    Route::post('deleteFaqCategory', 'deleteFaqCategory');
    Route::post('updateStatus', 'updateStatus');
});

Route::prefix('v2')->controller(StageGlobalReachController::class)->group(function () {
    Route::post('globalReachList', 'globalReachList');
    Route::post('storeglobalReach', 'storeglobalReach');
    Route::post('updateglobalReach', 'updateglobalReach');
    Route::post('deleteglobalReach', 'deleteglobalReach');
});

Route::prefix('v2')->controller(StageTestimonialController::class)->group(function () {
    Route::post('testimonialList', 'testimonialList');
    Route::post('testimonial', 'testimonial');
    Route::post('storeTestimonial', 'storeTestimonial');
    Route::post('updateTestimonial', 'updateTestimonial');
    Route::post('deleteTestimonial', 'deleteTestimonial');
});

Route::prefix('v2')->controller(StageTeamMembersController::class)->group(function () {
    Route::post('teamMembersList', 'teamMembersList');
    Route::post('storeTeamMember', 'storeTeamMember');
    Route::post('updateTeamMember', 'updateTeamMember');
    Route::post('deleteTeamMember', 'deleteTeamMember');
});

Route::prefix('v2')->controller(StageApiController::class)->group(function () {
    Route::post('getAllMenus', 'getAllMenus');
    Route::post('createMenu', 'createMenu');
    Route::post('updateMenu', 'updateMenu');
    Route::post('deleteMenu', 'deleteMenu');
    Route::post('getAllOffices', 'getAllOffices');
    Route::post('createGetintuch', 'createGetintuch');
    Route::post('submitResume', 'submitResume');
    Route::post('getOfficeById', 'getOfficeById');
    Route::post('getteammemberById', 'getteammemberById');
    Route::post('getblogdetailsById', 'getblogdetailsById');
    Route::post('adminLogin', 'adminLogin');
    Route::post('homePage', 'homePage');
    Route::post('getFooter', 'getFooter');
    Route::post('allBlogs', 'allBlogs');
    Route::post('enquiry', 'store');
    Route::post('getAllaudit', 'audit_and_assurances');
    Route::post('companyformation', 'company_formation');
    Route::post('getblogdetailsBySlug', 'getblogdetailsBySlug');
    Route::post('gethomeServiceBlock', 'gethomeServiceBlock');

    
});

Route::prefix('v2')->controller(MenuController::class)->group(function () {
    Route::post('getInTouchStore','storeLead');
});


