<?php $__env->startSection('toolbar-heading','Team Members'); ?>
<?php $__env->startSection('breadcrumb','Home'); ?>
<?php $__env->startSection('breadcrumb1','Team Members'); ?>
<?php $__env->startSection('action-btn'); ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_team_members')): ?>
    <a href="<?php echo e(route('team-member.create')); ?>" class="btn btn-sm btn-primary">Create</a>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_users_table">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">#</th>
                    <th class="min-w-125px">Image</th>
                    <th class="min-w-125px">Name</th>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_team_members')): ?>
                        <th class="min-w-125px">Status</th>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_team_members','delete_team_members'])): ?>
                        <th class="text-end min-w-70px">Actions</th>
                    <?php endif; ?>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600">
                <?php $__currentLoopData = $teamMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $teamMember): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td>
                            <img src="<?php echo e(get_file('team-members',$teamMember->image)); ?>" width="60px" height="60px" alt="Profile Image">
                        </td>
                        <td><?php echo e($teamMember->name); ?></td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_team_members')): ?>
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="<?php echo e($teamMember->id); ?>" <?php echo e($teamMember->status ? 'checked' : ''); ?>>
                                </div>
                            </td>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_team_members','delete_team_members'])): ?>
                            <td class="text-end">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_team_members')): ?>
                                    <a href="<?php echo e(route('team-member.edit',$teamMember->id)); ?>" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_team_members')): ?>
                                    <a href="#" onclick="delete_this('<?php echo e(route('team-member.destroy',$teamMember->id)); ?>','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('java-script'); ?>
    <script>
        $('#kt_users_table').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '<?php echo e(route('team-member-status')); ?>',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','<?php echo e(__('Something went wrong')); ?>');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/swipetoshared/public_html/resources/views/backend/team-members/index.blade.php ENDPATH**/ ?>