<?php $__env->startSection('toolbar-heading','Hero Section'); ?>
<?php $__env->startSection('breadcrumb','Home'); ?>
<?php $__env->startSection('breadcrumb1','Hero Section'); ?>
<?php $__env->startSection('action-btn'); ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create_hero_section')): ?>
    <a href="<?php echo e(route('hero-section.create')); ?>" class="btn btn-sm btn-primary">Create</a>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                    <th class="min-w-125px">Image</th>
                    <th class="min-w-125px">Title</th>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_hero_section')): ?>
                        <th class="min-w-125px">Status</th>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_hero_section','delete_hero_section'])): ?>
                        <th class="text-end min-w-70px">Actions</th>
                    <?php endif; ?>
                </tr>
                </thead>
                <tbody class="fw-semibold text-gray-600 cursor-move" id="sortable">
                <?php $__currentLoopData = $heroSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $heroSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-index-no="<?php echo e($heroSection->id); ?>">
                        <td><img src="<?php echo e(get_file('hero-section',$heroSection->image)); ?>" width="60px" height="60px" alt="Image"></td>
                        <td><?php echo e($heroSection->title); ?></td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_hero_section')): ?>
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input status" type="checkbox" role="switch" value="<?php echo e($heroSection->id); ?>" <?php echo e($heroSection->status ? 'checked' : ''); ?>>
                                </div>
                            </td>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['edit_hero_section','delete_hero_section'])): ?>
                            <td class="text-end">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_hero_section')): ?>
                                    <a href="<?php echo e(route('hero-section.edit',$heroSection->id)); ?>" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-pencil-fill fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_hero_section')): ?>
                                    <a href="#" onclick="delete_this('<?php echo e(route('hero-section.destroy',$heroSection->id)); ?>','Delete')" class="btn btn-sm btn-icon btn-bg-light btn-active-color-primary w-30px h-30px">
                                        <span class="svg-icon svg-icon-5 svg-icon-gray-700">
                                            <i class="bi bi-trash3 fs-7"></i>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('java-script'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.3/jquery-ui.min.js"></script>
    <script>
        //$('#sortable').dataTable();
        $(document).on('click', '.status', function ()
        {
            var status = $(this).is(":checked") ? 1 : 0;
            var id = $(this).val();
            $.ajax({
                url: '<?php echo e(route('hero-status')); ?>',
                type: "GET",
                data: {
                    'id' : id,
                    'status' : status,
                },
                dataType: "json",
                success:function(response) {
                    createToast(response.status,response.message);
                }, error: function (response){
                    createToast('error','<?php echo e(__('Something went wrong')); ?>');
                }
            });
        });

        $('#sortable').sortable({
            axis: 'y',
            stop: function (event, ui) {
                var order = [];
                $('tr').each(function() {
                    if($(this).data('index-no') != undefined) {
                        order.push($(this).data('index-no'));
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('sort-hero-section')); ?>",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        order: order,
                    },
                    type: 'POST',
                    error: function (data) {
                        createToast('error', 'Something went wrong!');
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/swipetoshared/public_html/admin/resources/views/backend/hero-section/index.blade.php ENDPATH**/ ?>