<!DOCTYPE html>
<html lang="en">
<!--begin::Head-->
<head>
    <title><?php echo e(get_setting('app_name')); ?></title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" href="<?php echo e(get_favicon()); ?>" type="image" sizes="16x16">
    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
    <!--end::Fonts-->
    <!--begin::Vendor Stylesheets(used for this page only)-->
    <link href="<?php echo e(asset('assets/dashboard/plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Vendor Stylesheets-->
    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="<?php echo e(asset('assets/dashboard/plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dashboard/plugins/global/plugins-custom.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dashboard/plugins/custom/fullcalendar/fullcalendar.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dashboard/plugins/custom/flatpickr/flatpickr.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dashboard/css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dashboard/css/custom.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dashboard/css/toast.css')); ?>" rel="stylesheet" type="text/css" />
    <!--end::Global Stylesheets Bundle-->
    <?php echo $__env->yieldPushContent('css'); ?>
</head>
<!--end::Head-->
<!--begin::Body-->
<body id="kt_app_body" data-kt-app-layout="dark-sidebar" data-kt-app-header-fixed="true" data-kt-app-sidebar-enabled="true" data-kt-app-sidebar-fixed="true" data-kt-app-sidebar-hoverable="true" data-kt-app-sidebar-push-header="true" data-kt-app-sidebar-push-toolbar="true" data-kt-app-sidebar-push-footer="true" data-kt-app-toolbar-enabled="true" class="app-default">
<!--begin::Theme mode setup on page load-->
<script>var defaultThemeMode = "light"; var themeMode; if ( document.documentElement ) { if ( document.documentElement.hasAttribute("data-bs-theme-mode")) { themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); } else { if ( localStorage.getItem("data-bs-theme") !== null ) { themeMode = localStorage.getItem("data-bs-theme"); } else { themeMode = defaultThemeMode; } } if (themeMode === "system") { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } document.documentElement.setAttribute("data-bs-theme", themeMode); }</script>
<!--end::Theme mode setup on page load-->
<!--begin::App-->
<div class="d-flex flex-column flex-root app-root" id="kt_app_root">
    <!--begin::Page-->
    <div class="app-page flex-column flex-column-fluid" id="kt_app_page">
        <?php echo $__env->make('layouts.partials.dashboard.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--begin::Wrapper-->
        <div class="app-wrapper flex-column flex-row-fluid" id="kt_app_wrapper">
            <?php echo $__env->make('layouts.partials.dashboard.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!--begin::Main-->
            <div class="app-main flex-column flex-row-fluid" id="kt_app_main">
                <!--begin::Content wrapper-->
                <div class="d-flex flex-column flex-column-fluid">
                    <?php echo $__env->make('layouts.partials.dashboard.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!--begin::Content-->
                    <div id="kt_app_content" class="app-content flex-column-fluid">
                        <!--begin::Content container-->
                        <div id="kt_app_content_container" class="app-container container-fluid">
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                        <!--end::Content container-->
                    </div>
                    <!--end::Content-->
                </div>
                <!--end::Content wrapper-->
                <!--begin::Footer-->
                <div id="kt_app_footer" class="app-footer">
                    <?php echo $__env->make('layouts.partials.dashboard.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <!--end::Footer-->
            </div>
            <!--end:::Main-->
        </div>
        <!--end::Wrapper-->
    </div>
    <!--end::Page-->
</div>

<!--end::App-->
<ul class="toast-notifications"></ul>
<!--begin::Scrolltop-->
<div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
    <!--begin::Svg Icon | path: icons/duotune/arrows/arr066.svg-->
    <span class="svg-icon">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor" />
            <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor" />
        </svg>
    </span>
    <!--end::Svg Icon-->
</div>
<!--end::Scrolltop-->
<div class="modal fade" role="dialog" id="dynamic-modal">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content"></div>
    </div>
</div>
<div class="modal fade text-white" id="modal-notification" tabindex="-1" role="dialog" aria-labelledby="modal-notification" style="display: none; padding-right: 16px;" aria-modal="true">
    <div class="modal-dialog modal-danger modal-dialog-centered modal-" role="document">
        <div class="modal-content bg-danger">
            <div class="modal-header border-0">
                <button type="button" class="delete-modal-close-btn" data-dismiss="modal" aria-label="Close" onclick="closeModal()">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body border-0">
                <div class="py-3 text-center">
                    <i class="far fa-bell fs-1 text-white"></i>
                    <h4 class="heading mt-4 modal-title text-white"></h4>
                    <p class="modal-message"></p>
                </div>
            </div>
            <div class="modal-footer border-0">
                <form id="modal-notification-form" method="POST">
                    <?php echo e(csrf_field()); ?>

                    <?php echo e(method_field('DELETE')); ?>

                    <button type="submit" class="btn btn-light"><?php echo e(__('Yes, Delete it')); ?></button>
                </form>
            </div>
        </div>
    </div>
</div>
<!--begin::Javascript-->
<script>var hostUrl = "assets/";</script>
<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<script src="<?php echo e(asset('assets/dashboard/plugins/global/plugins.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/dashboard/js/scripts.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/dashboard/js/plugins/datatables/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/dashboard/plugins/custom/fullcalendar/fullcalendar.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/dashboard/plugins/custom/flatpickr/flatpickr.bundle.js')); ?>"></script>
<!--end::Global Javascript Bundle-->
<script src="<?php echo e(asset('assets/dashboard/js/custom/custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/dashboard/js/custom/toast.js')); ?>"></script>
<?php if(\Session::has('success')): ?>
    <script>createToast('success','<?php echo \Session::get('success'); ?>');</script>
    <?php echo e(\Session::forget('success')); ?>

<?php endif; ?>
<?php if(\Session::has('error')): ?>
    <script>createToast('error','<?php echo \Session::get('error'); ?>');</script>
    <?php echo e(\Session::forget('error')); ?>

<?php endif; ?>
<?php echo $__env->yieldPushContent('java-script'); ?>
</body>
<!--end::Body-->
</html>
<?php /**PATH /home/swipetoshared/public_html/resources/views/layouts/dashboard.blade.php ENDPATH**/ ?>