<?php $__env->startSection('toolbar-heading','Sitemap'); ?>
<?php $__env->startSection('breadcrumb','Sitemap'); ?>
<?php $__env->startSection('content'); ?>


<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            
            <div class="text-center mb-4">
                <h2 class="fw-bold text-primary">
                    🌐 Sitemap & Robots Manager
                </h2>
                <p class="text-muted">Manage your website’s sitemap and robots.txt file easily.</p>
            </div>

            
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
                    <?php echo session('success'); ?>

                    <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">&times;</button>
                </div>
            <?php endif; ?>

            
            <div class="card shadow-sm mb-4 border-0 rounded-3">
                <div class="card-body">
                    <h5 class="card-title mb-3">
                        ⚙️ Generate Sitemap
                    </h5>
                    <p class="text-muted mb-3">Click below to generate or refresh your sitemap.xml file.</p>

                    <form method="POST" action="<?php echo e(route('sitemap.generate')); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-primary px-4">
                            <i class="fas fa-sync-alt me-1"></i> Generate Sitemap
                        </button>
                    </form>

                    <hr class="my-4">
                    <p class="mb-0">
                        <strong>Current Sitemap:</strong><br>
                        <?php if(file_exists(base_path('../sitemap.xml'))): ?>
                            <a href="https://elevatebpm.com/sitemap.xml" target="_blank" class="text-decoration-none">
                                🌍 https://elevatebpm.com/sitemap.xml
                            </a>
                        <?php else: ?>
                            <em class="text-muted">No sitemap generated yet.</em>
                        <?php endif; ?>
                    </p>
                </div>
            </div>

            
            <div class="card shadow-sm border-0 rounded-3">
                <div class="card-body">
                    <h5 class="card-title mb-3">
                        🤖 Upload robots.txt
                    </h5>
                    <p class="text-muted mb-3">Upload a new <code>robots.txt</code> file. Existing one will be replaced automatically.</p>

                    <form method="POST" action="<?php echo e(route('robots.upload')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <input type="file" name="robots_file" class="form-control" accept=".txt" required>
                        </div>
                        <button class="btn btn-success px-4">
                            <i class="fas fa-upload me-1"></i> Upload robots.txt
                        </button>
                    </form>

                    <hr class="my-4">
                    <p class="mb-0">
                        <strong>Current robots.txt:</strong><br>
                        <?php if(file_exists(base_path('../robots.txt'))): ?>
                            <a href="https://elevatebpm.com/robots.txt" target="_blank" class="text-decoration-none">
                                📄 https://elevatebpm.com/robots.txt
                            </a>
                        <?php else: ?>
                            <em class="text-muted">No robots.txt uploaded yet.</em>
                        <?php endif; ?>
                    </p>
                </div>
            </div>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('java-script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elevatebpm/public_html/admin/resources/views/backend/sitemap/index.blade.php ENDPATH**/ ?>