# ThemeJunction elementor core plugin.

**Contributors:** [ThemeJunction](https://themejunction.net/)

**Tags:** elementor, elements, addons, elementor addons, elementor widget, elementor form, woocommerce elementor, page builder, builder, visual editor, wordpress page builder

**Requires at least:** 6.0

**Tested up to:** 6.9

**Requires PHP:** 8.1

**License:** GPLv3

**License URI:** https://opensource.org/licenses/GPL-3.0

The [TJ Core](https://themejunction.net/) plugin you install after Elementor! Packed with 40+ stunning free elements including Advanced Data Table, Event Calendar, Filterable Gallery, WooCommerce, and many more.

Enhance your [Elementor](https://wordpress.org/plugins/elementor/) page building experience with 90+ creative elements and extensions. Add powers to your page builder using our easy-to-use elements those were designed to make your next WordPress page and posts design easier and prettier than ever before.

With this TJ Core Plugin we've extended elementor custom functionality to [Elementor](https://github.com/pojome/elementor/)

#### Plugin Structure:

```
assets/
      /js
      /css

inc/
  /builder
  /custom-post
  /demo-importer
  /elementor
  /helpers
  /icons
  /widgets

languages

index.php
plugin.php
tj-core.php
```

- `assets` directory - holds plugin JavaScript and CSS assets
  - `/js` directory - Holds plugin Javascript Files
  - `/css` directory - Holds plugin CSS Files
- `inc` directory - holds plugin external includes
  - `/builder` directory - Holds plugin Header & Footer Builder files/Class
  - `/custom-post` directory - Holds plugin Custom Post Type
  - `/demo-importer` directory - Holds plugin One Click Demo Importer file
  - `/elementor` directory - Holds plugin Custom Elementor Widgets
  - `/helpers` directory - Holds plugin Helper Functions (necessary functions)
  - `/icons` directory - Holds plugin Custom Icon Support
  - `/widgets` directory - Holds plugin widgets
- `languages` directory - Holds Plugin Languages Pot File
- `index.php` - Prevent direct access to directories
- `plugin.php` - The actual Plugin file/Class.
- `tj-core.php` - Main plugin file, used as a loader if plugin minimum requirements are met.

For more documentation please see [Elementor Developers Resource](https://developers.elementor.com/creating-an-extension-for-elementor/).
