<?php

/**
 * TJ Header Builder
 *
 * @author 		ThemeJunction 
 * @package 	TJCore
 * @version 	1.0.0
 * 
 * Class TJ_Header_Builder
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


class TJ_Header_Builder {

  // Construct
  function __construct() {
    add_action('init', array($this, 'register_custom_post_type'));
  }

  // Register Custom Post Type
  public function register_custom_post_type() {

    $labels = array(
      'name'                  => esc_html_x('TJ Header Builder', 'Post Type General Name', 'tjcore'),
      'singular_name'         => esc_html_x('TJ Header Builder', 'Post Type Singular Name', 'tjcore'),
      'menu_name'             => esc_html__('TJ Header Builder', 'tjcore'),
      'add_new_item'          => esc_html__('Add New Header', 'tjcore'),
      'edit_item'             => esc_html__('Edit Header', 'tjcore'),
      'new_item'              => esc_html__('New Header', 'tjcore'),
      'view_item'             => esc_html__('View Header', 'tjcore'),
      'search_items'          => esc_html__('Search Header', 'tjcore'),
      'not_found'             => esc_html__('Not Header found', 'tjcore'),
      'parent_item_colon'     => esc_html__('Parent Header:', 'tjcore'),
      'not_found_in_trash'    => esc_html__('No Header found in Trash', 'tjcore'),
    );

    $args   = array(
      'labels'                => $labels,
      'public'                => true,
      'show_in_menu'          => 'themes.php',
      'menu_icon' => '',
      'supports'              => ['title', 'elementor'],
      'capability_type' => 'post',
    );

    register_post_type('tj-header-builder', $args);
    flush_rewrite_rules(false);
  }
}
new TJ_Header_Builder();
