<?php

/**
 * TJ Header Footer Builder
 *
 * @author 		ThemeJunction 
 * @package 	TJCore
 * @version 	1.0.0
 * 
 * Class TJ_HF_Builder
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


class TJ_HF_Builder
{

  // Current theme template
  public $template;

  // Instance of Elementor Frontend class.
  private static $elementor_instance;

  // Instance of HFE_Admin
  private static $_instance = null;

  // Instance of TJ_HF_Builder
  public static function instance()
  {
    if (!isset(self::$_instance)) {
      self::$_instance = new self();
    }

    return self::$_instance;
  }

  // Constructor
  function __construct()
  {

    $is_elementor_callable = (defined('ELEMENTOR_VERSION') && is_callable('Elementor\Plugin::instance')) ? true : false;

    $required_elementor_version = '3.5.0';

    $is_elementor_outdated = ($is_elementor_callable && (!version_compare(ELEMENTOR_VERSION, $required_elementor_version, '>='))) ? true : false;

    // if ((!$is_elementor_callable) || $is_elementor_outdated) {
    //   $this->elementor_not_available($is_elementor_callable, $is_elementor_outdated);
    // }

    if ($is_elementor_callable) {
      self::$elementor_instance = Elementor\Plugin::instance();

      // Include Header Footer Post Type
      include TJCORE_INC_PATH . '/builder/tj-header-builder.php';
      include TJCORE_INC_PATH . '/builder/tj-footer-builder.php';
      include TJCORE_INC_PATH . '/builder/tj-megamenu-builder.php';


      add_shortcode('hfe_template', [$this, 'render_template']);
      add_filter('single_template', [$this, 'tj_canvas_template']);
    }
  }

  // Canvas Single Template
  public function tj_canvas_template($single_template)
  {
    global $post;
    if ('tj-header-builder' == $post->post_type || 'tj-footer-builder' == $post->post_type || 'tj-megamenu-builder' == $post->post_type) {
      return ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';
    }
    return $single_template;
  }

  // Show the header template
  public static function render_template($id)
  {
    self::$elementor_instance = Elementor\Plugin::instance();
    echo self::$elementor_instance->frontend->get_builder_content_for_display($id);
  }

  // get posts
  public static function get_posts($post_type)
  {
    $args = [
      'posts_per_page' => -1,
      'post_status' => 'publish',
      'orderby' => 'id',
      'order' => 'DESC',
      'fields' => 'ids',
      'post_type' => $post_type,
    ];

    return get_posts($args);
  }
}
new TJ_HF_Builder();
