<?php

/**
 * Plugin Name: TJ Mega Menu Builder
 * Description: Elementor-based Mega Menu with switch, custom class, width, and template selector.
 * Version: 1.0.0
 * Author: Theme Junction
 */

// Block direct access
if (!defined('ABSPATH')) exit;

/**
 * Register Megamenu Template Post Type
 */
class TJ_Megamenu_Builder
{
  public function __construct()
  {
    add_action('init', [$this, 'register_custom_post_type']);
  }

  public function register_custom_post_type()
  {
    $labels = [
      'name' => esc_html__('TJ Megamenu Builder', 'tjcore'),
      'singular_name' => esc_html__('TJ Megamenu Builder', 'tjcore'),
      'menu_name' => esc_html__('TJ Megamenu Builder', 'tjcore'),
      'add_new_item' => esc_html__('Add New Megamenu', 'tjcore'),
    ];

    $args = [
      'labels' => $labels,
      'public' => true,
      'show_ui' => true,
      'show_in_menu' => 'themes.php',
      'show_in_elementor' => true,
      'supports' => ['title', 'elementor'],
      'capability_type' => 'post',
      'menu_position' => 25,
    ];

    register_post_type('tj-megamenu-builder', $args);
  }
}
new TJ_Megamenu_Builder();

/**
 * Mega Menu Custom Fields
 */
function tj_mega_menu_custom_fields($item_id, $item)
{
  $menu_item_elementor_template = get_post_meta($item_id, '_menu_item_elementor_template', true);
  $menu_item_width = get_post_meta($item_id, '_menu_item_width', true);
  $menu_item_switch = get_post_meta($item_id, '_menu_item_switch', true);
  $custom_class = get_post_meta($item_id, '_menu_item_layout', true); // renamed field
  $checked = $menu_item_switch ? 'checked' : '';

  $post_args = [
    'post_status' => 'publish',
    'post_type' => 'tj-megamenu-builder',
    'posts_per_page' => -1,
  ];
  $pro_query = new WP_Query($post_args);
?>

  <!-- Enable Switch -->
  <p class="description description-wide">
    <label for="edit-menu-item-switch-<?php echo esc_attr($item_id); ?>">
      <?php _e('Enable Megamenu'); ?>
      <label class="tj-switch">
        <input type="checkbox" class="tj-megamenu-toggle" id="edit-menu-item-switch-<?php echo esc_attr($item_id); ?>" name="menu-item-switch[<?php echo esc_attr($item_id); ?>]" value="1" <?php echo $checked; ?>>
        <span class="slider round"></span>
      </label>
    </label>
  </p>

  <!-- Elementor Template -->
  <div class="tj_megamenu_options_container" style="display: <?php echo $checked ? 'block' : 'none'; ?>">
    <p class="description description-wide">
      <label for="menu_item_elementor_template-<?php echo esc_attr($item_id); ?>">
        <?php esc_html_e('Mega Menu Template', 'tjcore'); ?><br />
        <select class="widefat" id="menu_item_elementor_template-<?php echo esc_attr($item_id); ?>" name="menu_item_elementor_template[<?php echo esc_attr($item_id); ?>]">
          <option value="-1"><?php echo esc_html__('Select A Menu', 'tjcore') ?></option>
          <?php while ($pro_query->have_posts()) : $pro_query->the_post(); ?>
            <?php $selected = ($menu_item_elementor_template == get_the_ID()) ? "selected='selected'" : ''; ?>
            <option value="<?php echo esc_attr(get_the_ID()) ?>" <?php echo $selected; ?>><?php echo esc_html(get_the_title()) ?></option>
          <?php endwhile; ?>
        </select>
      </label>
    </p>

    <!-- Custom Class Input -->
    <p class="description description-wide tj-megamenu-layout" style="display: <?php echo $checked ? 'block' : 'none'; ?>">
      <label for="edit-menu-item-layout-<?php echo esc_attr($item_id); ?>">
        <?php _e('Megamenu Custom Class'); ?><br>
        <input class="widefat" type="text" id="edit-menu-item-layout-<?php echo esc_attr($item_id); ?>"
          name="menu-item-layout[<?php echo esc_attr($item_id); ?>]"
          value="<?php echo esc_attr($custom_class); ?>"
          placeholder="<?php esc_attr_e('type custom class name', 'tjcore'); ?>" />
      </label>
    </p>
    <!-- Custom width -->
    <p class="description description-wide">
      <label for="menu_item_width-<?php echo esc_attr($item_id); ?>">
        <?php esc_html_e('Megamenu Width (px)', 'tjcore'); ?><br />
        <input class="widefat" type="text" name="menu_item_width[<?php echo esc_attr($item_id); ?>]" id="menu_item_width-<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($menu_item_width); ?>" placeholder="<?php esc_attr_e('Type only number here', 'tjcore'); ?>" />
      </label>
    </p>
  </div>

<?php
  wp_reset_postdata();
}
add_action('wp_nav_menu_item_custom_fields', 'tj_mega_menu_custom_fields', 10, 2);

/**
 * Save Mega Menu Fields
 */
function tj_mega_menu_custom_fields_save($menu_id, $menu_item_db_id)
{
  // Switch
  if (isset($_POST['menu-item-switch'][$menu_item_db_id])) {
    update_post_meta($menu_item_db_id, '_menu_item_switch', 1);
  } else {
    delete_post_meta($menu_item_db_id, '_menu_item_switch');
  }

  // Custom Class
  if (isset($_POST['menu-item-layout'][$menu_item_db_id])) {
    $layout = sanitize_text_field($_POST['menu-item-layout'][$menu_item_db_id]);
    update_post_meta($menu_item_db_id, '_menu_item_layout', $layout);
  } else {
    delete_post_meta($menu_item_db_id, '_menu_item_layout');
  }

  // Width
  if (isset($_POST['menu_item_width'][$menu_item_db_id])) {
    $width = sanitize_text_field($_POST['menu_item_width'][$menu_item_db_id]);
    update_post_meta($menu_item_db_id, '_menu_item_width', $width);
  } else {
    delete_post_meta($menu_item_db_id, '_menu_item_width');
  }

  // Template
  if (isset($_POST['menu_item_elementor_template'][$menu_item_db_id])) {
    $template_id = absint($_POST['menu_item_elementor_template'][$menu_item_db_id]);
    update_post_meta($menu_item_db_id, '_menu_item_elementor_template', $template_id);
  } else {
    delete_post_meta($menu_item_db_id, '_menu_item_elementor_template');
  }
}
add_action('wp_update_nav_menu_item', 'tj_mega_menu_custom_fields_save', 10, 2);

/**
 * Add Meta to Menu Item Object
 */
function tj_mega_menu_load_meta($items)
{
  foreach ($items as $item) {
    $item->custom_switch = get_post_meta($item->ID, '_menu_item_switch', true);
    $item->megamenu_layout = get_post_meta($item->ID, '_menu_item_layout', true);
  }
  return $items;
}
add_filter('wp_get_nav_menu_items', 'tj_mega_menu_load_meta');


/**
 * Admin JS to Toggle Fields
 */
add_action('admin_footer-nav-menus.php', function () {
?>
  <script>
    jQuery(document).ready(function($) {
      function toggleFields() {
        $('.menu-item').each(function() {
          const $checkbox = $(this).find('.tj-megamenu-toggle');
          const isChecked = $checkbox.is(':checked');
          $(this).find('.tj-megamenu-layout').toggle(isChecked);
          $(this).find('.tj_megamenu_options_container').toggle(isChecked);
        });
      }
      toggleFields();
      $(document).on('change', '.tj-megamenu-toggle', function() {
        toggleFields();
      });
    });
  </script>
  <style>
    .tj-switch {
      display: inline-block;
      position: relative;
      width: 46px;
      height: 24px;
    }

    .tj-switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }

    .slider {
      position: absolute;
      cursor: pointer;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background-color: #ccc;
      transition: .4s;
      border-radius: 24px;
    }

    .slider:before {
      position: absolute;
      content: "";
      height: 18px;
      width: 18px;
      left: 3px;
      bottom: 3px;
      background-color: white;
      transition: .4s;
      border-radius: 50%;
    }

    input:checked+.slider {
      background-color: #007cba;
    }

    input:checked+.slider:before {
      transform: translateX(22px);
    }
  </style>
<?php
});
