<?php


$tjSectionTitle   = $settings['tj_sec_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "";

// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $headingClass = "tj-evolute-title mb-30 wow $tjAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} elseif ($tj_gsap_animation) {
  $headingClass = "tj-evolute-title mb-30 text-anim";
} else {
  $headingClass = "tj-evolute-title mb-30";
}
$this->add_render_attribute('title_args', 'class', $headingClass);


$tjShowContent   = !empty($settings['is_content']) ? "yes" : "no";
$tjSectionContent   = $settings['tj_content'] ?? "";
// animation
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';
if (!empty($tjContentAnimation)) {
  $contentClass = "desc mb-60 wow $tjContentAnimationName";
  $this->add_render_attribute('content_args', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc mb-60";
}
$this->add_render_attribute('content_args', 'class', $contentClass);

// video
$tjCircleIcon = $settings['tj_circle_icon'] ?? "";
$tjCircleVideoLink = $settings['tj_circle_video_link'] ?? "";
$tj_subtitle = $settings['tj_vsubtitle'] ?? "";
$tj_title = $settings['tj_vtitle'] ?? "";

// images animation
$tjimgAnimation   = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName   = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay   = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "tj-evolute-image hover:shine wow $tjimgAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "tj-evolute-image hover:shine";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);


// wrapper animation
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$wrapperClass = "tj-evolute-counter";
if (!empty($tjButtonAnimation)) {
  $wrapperClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapperClass);

$counters = !empty($settings['tj_counter_list']) ? $settings['tj_counter_list'] : [];

?>

<section class="tj-evolute-area">
  <div class="container-fluid p-0 d-none d-xxl-block">
    <div class="row g-0">
      <div class="col-lg-7">
        <div class="tj-evolute">
          <?php
          if (!empty($tjSectionTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjSectionTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($tjSectionTitle)
            );
          endif;
          ?>
          <?php if ("yes" == $tjShowContent) : ?>
            <div <?php echo $this->get_render_attribute_string('content_args'); ?>>
              <?php echo tj_kses($tjSectionContent); ?>
            </div>
          <?php endif; ?>
          <?php if (count($counters) > 0): ?>
            <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
              <?php foreach ($counters as $item):
                $tjCounterCount = (!empty($item['tj_ff_number'])) ? $item['tj_ff_number'] : "";
                $tjCounterPrefix = (!empty($item['tj_ff_prefix'])) ? $item['tj_ff_prefix'] : "";
                $tjCounterSuffix = (!empty($item['tj_ff_suffix'])) ? $item['tj_ff_suffix'] : "";
                $tjCounterTitle = (!empty($item['tj_ff_title'])) ? $item['tj_ff_title'] : "";
              ?>
                <div class="counter-item">
                  <div class="number">
                    <?php echo esc_html($tjCounterPrefix); ?>
                    <span class="odometer" data-count="<?php echo esc_html($tjCounterCount); ?>">0</span>
                    <?php echo esc_html($tjCounterSuffix); ?>
                  </div>
                  <?php if (!empty($tjCounterTitle)): ?>
                    <span class="sub-title">
                      <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
                    </span>
                  <?php endif; ?>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-lg-5">
        <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
          <?php if (!empty($settings['tj_image']['url'])): ?>
            <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
          <?php endif; ?>
          <?php if (!empty($tjCircleVideoLink)): ?>
            <div class="about-video-box style-2">
              <div class="video-box">
                <a class="circle video-popup" data-autoplay="true" data-vbtype="video"
                  data-maxwidth="1200px" href="<?php echo esc_url($tjCircleVideoLink); ?>">
                  <?php if (!empty($tjCircleIcon['value'])): ?>
                    <?php tj_render_icon($settings, 'circle_icon', 'tj_circle_icon') ?>
                  <?php endif; ?>
                </a>
              </div>
              <?php if (!empty($tj_subtitle)): ?>
                <span class="sub-title"><?php echo esc_html($tj_subtitle); ?></span>
              <?php endif; ?>
              <?php if (!empty($tj_title)): ?>
                <h5 class="title"><?php echo esc_html($tj_title); ?></h5>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <!-- lg device -->
  <div class="container d-xxl-none">
    <div class="row rg-50 align-items-center">
      <div class="col-xl-6 col-12">
        <div class="tj-evolute">
          <?php
          if (!empty($tjSectionTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjSectionTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($tjSectionTitle)
            );
          endif;
          ?>
          <?php if ("yes" == $tjShowContent) : ?>
            <div <?php echo $this->get_render_attribute_string('content_args'); ?>>
              <?php echo tj_kses($tjSectionContent); ?>
            </div>
          <?php endif; ?>
          <?php if (count($counters) > 0): ?>
            <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
              <?php foreach ($counters as $item):
                $tjCounterCount = (!empty($item['tj_ff_number'])) ? $item['tj_ff_number'] : "";
                $tjCounterPrefix = (!empty($item['tj_ff_prefix'])) ? $item['tj_ff_prefix'] : "";
                $tjCounterSuffix = (!empty($item['tj_ff_suffix'])) ? $item['tj_ff_suffix'] : "";
                $tjCounterTitle = (!empty($item['tj_ff_title'])) ? $item['tj_ff_title'] : "";
              ?>
                <div class="counter-item">
                  <div class="number">
                    <?php echo esc_html($tjCounterPrefix); ?>
                    <span class="odometer" data-count="<?php echo esc_html($tjCounterCount); ?>">0</span>
                    <?php echo esc_html($tjCounterSuffix); ?>
                  </div>
                  <?php if (!empty($tjCounterTitle)): ?>
                    <span class="sub-title">
                      <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
                    </span>
                  <?php endif; ?>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-xl-6 col-12">
        <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
          <?php if (!empty($settings['tj_image']['url'])): ?>
            <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
          <?php endif; ?>
          <?php if (!empty($tjCircleVideoLink)): ?>
            <div class="about-video-box style-2">
              <div class="video-box">
                <a class="circle video-popup" data-autoplay="true" data-vbtype="video"
                  data-maxwidth="1200px" href="<?php echo esc_url($tjCircleVideoLink); ?>">
                  <?php if (!empty($tjCircleIcon['value'])): ?>
                    <?php tj_render_icon($settings, 'circle_icon', 'tj_circle_icon') ?>
                  <?php endif; ?>
                </a>
              </div>
              <?php if (!empty($tj_subtitle)): ?>
                <span class="sub-title"><?php echo esc_html($tj_subtitle); ?></span>
              <?php endif; ?>
              <?php if (!empty($tj_title)): ?>
                <h5 class="title"><?php echo esc_html($tj_title); ?></h5>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>