<?php
$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);


$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "";
// animation
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title text-anim";
} else {
  $titleClass = "sec-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);


$tjShowContent   = !empty($settings['is_content']) ? "yes" : "no";
$tjSectionContent   = $settings['tj_content'] ?? "";
// animation
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';
if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('content_args', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('content_args', 'class', $contentClass);


// images
$tj_image = !empty($settings['tj_image']) ? $settings['tj_image'] : "";
$tj_image2 = !empty($settings['tj_image2']) ? $settings['tj_image2'] : "";

// animation
$tjimgAnimation   = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName   = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay   = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "about-image-wrap hover:shine wow $tjimgAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "about-image-wrap hover:shine";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';

$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';

if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}

$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$btnClass = "tj-primary-btn";
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

$tjVideoIcon = $settings['tj_video_icon'] ?? "";
$tjVideoImage = $settings['tj_video_image'] ?? "";
$tjVideoLink = $settings['tj_video_link'] ?? "";


?>

<!-- start: About Section -->
<section class="tj-about-section-four">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="about-wrapper-three">
          <?php if (!empty($tj_image['url'])): ?>
            <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
              <?php if (!empty($tj_image['url'])): ?>
                <img src="<?php echo esc_url($tj_image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_image['id'], '_wp_attachment_image_alt', true)); ?>">
              <?php endif; ?>
              <?php if (!empty($tjVideoLink)): ?>
                <div class="circle-wrap el-circle">
                  <img class="rotate-image" src="<?php echo esc_url($tjVideoImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjVideoImage['id'], '_wp_attachment_image_alt', true)); ?>">
                  <?php if ($tjVideoIcon['value']): ?>
                    <a class="circle video-popup" data-autoplay="true" data-vbtype="video" data-maxwidth="1200px" id="video_popup-<?php echo esc_attr($this->get_id()); ?>"
                      href="<?php echo esc_url($tjVideoLink); ?>">
                      <span><?php tj_render_icon($settings, 'video_icon', 'tj_video_icon') ?></span>
                    </a>
                  <?php endif; ?>
                </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>
          <div class="about-content-four">
            <div class="sec-heading style-3">
              <?php if (!empty($tjSectionSubtitle)) : ?>
                <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
                  <?php echo esc_html($tjSectionSubtitle); ?>
                </span>
              <?php endif; ?>
              <?php
              if (!empty($tjSectionTitle)) :
                printf(
                  '<%1$s %2$s>%3$s</%1$s>',
                  tag_escape($tjSectionTitleTag),
                  $this->get_render_attribute_string('title_args'),
                  tj_kses($tjSectionTitle)
                );
              endif;
              ?>
            </div>
            <?php if (!empty($tjShowContent) || !empty($tjButtonShow) || !empty($tj_show_author)): ?>
              <div class="about-feature-item">
                <?php if (!empty($tjShowContent) || !empty($tjButtonShow)): ?>
                  <div class="feature-box">
                    <?php if ("yes" == $tjShowContent) : ?>
                      <div <?php echo $this->get_render_attribute_string('content_args'); ?>>
                        <?php echo tj_kses($tjSectionContent); ?>
                      </div>
                    <?php endif; ?>
                    <?php if ($tjButtonShow === 'yes'): ?>
                      <div class="about-button">
                        <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                          <span class="btn_inner">
                            <?php if (!empty($tjBtnIcon['value'])): ?>
                              <span class="btn_icon">
                                <span>
                                  <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                                  <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                                </span>
                              </span>
                            <?php endif; ?>
                            <?php if (!empty($tjBtnText)): ?>
                              <span class="btn_text">
                                <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                              </span>
                            <?php endif; ?>
                          </span>
                        </a>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if (!empty($tj_show_author)): ?>
                  <div class="feature-box">
                    <div class="about-author">
                      <div class="author-name">
                        <?php if (!empty($settings['tj_author_img']['url'])): ?>
                          <div class="author-img">
                            <img src="<?php echo esc_url($settings['tj_author_img']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_author_img']['id'], '_wp_attachment_image_alt', true)); ?>">
                          </div>
                        <?php endif; ?>
                        <?php if (!empty($settings['tj_name'])): ?>
                          <h5 class="title"><?php echo tj_kses($settings['tj_name']); ?></h5>
                        <?php endif; ?>
                        <?php if (!empty($settings['tj_job'])): ?>
                          <span class="sub-title"><?php echo tj_kses($settings['tj_job']); ?></span>
                        <?php endif; ?>
                      </div>
                      <?php if (!empty($settings['tj_signature']['url'])): ?>
                        <div class="signature">
                          <img src="<?php echo esc_url($settings['tj_signature']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_signature']['id'], '_wp_attachment_image_alt', true)); ?>">
                        </div>
                      <?php endif; ?>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
          <?php if (!empty($tj_image2['url'])): ?>
            <div class="about_images hover:shine wow fadeInUp" data-wow-delay="0.11s">
              <img src="<?php echo esc_url($tj_image2['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_image2['id'], '_wp_attachment_image_alt', true)); ?>">
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <div class="about-shapes move-anim">
    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/h4-hero-shape-1.svg" alt="Shapes">
  </div>
</section>

<!-- end: About Section -->