<?php

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
    $imageClass = "about-images-group-one hover:shine wow $tjAnimationName";
    $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
    $imageClass = "about-images-group-one hover:shine";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

?>

<div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
    <?php if (!empty($settings['tj_image']['url'])): ?>
        <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
    <?php endif; ?>
    <?php if (!empty($settings['tj_signature']['url']) || !empty($settings['tj_name']) || !empty($settings['tj_job'])): ?>
        <div class="about-author tj-wrap">
            <?php if (!empty($settings['tj_signature']['url'])): ?>
                <div class="signature">
                    <img src="<?php echo esc_url($settings['tj_signature']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_signature']['id'], '_wp_attachment_image_alt', true)); ?>">
                </div>
            <?php endif; ?>
            <?php if (!empty($settings['tj_name']) || !empty($settings['tj_job'])): ?>
                <div class="author-name">
                    <?php if (!empty($settings['tj_name'])): ?>
                        <h5 class="title"><?php echo tj_kses($settings['tj_name']); ?></h5>
                    <?php endif; ?>
                    <?php if (!empty($settings['tj_job'])): ?>
                        <span class="sub-title"><?php echo tj_kses($settings['tj_job']); ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>