<?php

$tjCounterCount = (!empty($settings['tj_ff_number'])) ? $settings['tj_ff_number'] : "";
$tjCounterPrefix = (!empty($settings['tj_ff_prefix'])) ? $settings['tj_ff_prefix'] : "";
$tjCounterSuffix = (!empty($settings['tj_ff_suffix'])) ? $settings['tj_ff_suffix'] : "";
$tjCounterTitle = (!empty($settings['tj_ff_title'])) ? $settings['tj_ff_title'] : "";

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
    $imageClass = "testimonial-images-2 hover:shine wow $tjAnimationName";
    $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
    $imageClass = "testimonial-images-2 hover:shine";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

?>

<div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
    <?php if (!empty($settings['tj_image']['url'])): ?>
        <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
    <?php endif; ?>
    <?php if (!empty($tjCounterTitle) || !empty($tjCounterCount)): ?>
        <div class="testimonial-funfact tj-wrap">
            <div class="number">
                <?php if (!empty($tjCounterPrefix)): ?><span><?php echo esc_html($tjCounterPrefix); ?></span><?php endif; ?><span class="odometer" data-count="<?php echo esc_attr($tjCounterCount); ?>"></span><?php if (!empty($tjCounterSuffix)): ?><span><?php echo esc_html($tjCounterSuffix); ?></span><?php endif; ?>
            </div>
            <?php if (!empty($tjCounterTitle)): ?>
                <span class="sub-title">
                    <?php echo tj_kses($tjCounterTitle); ?>
                </span>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>