<?php
$tjImageTitle      = $settings['tj_image_title'] ?? '';

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

$imageClass = "about-images-group-three hover:shine";
if (!empty($tjAnimation)) {
  $imageClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

// circle
$tjCircleShow = $settings['tj_circle_show'] ?? "";
$tjCircleImage = $settings['tj_circle_image'] ?? "";
$tjCircleIconImage = $settings['tj_icon_image'] ?? "";
?>


<div <?php $this->print_render_attribute_string('tj-image-arg'); ?>>
  <?php if (!empty($settings['tj_image']['url'])): ?>
    <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
  <?php endif; ?>

  <?php if (!empty($tjCircleShow)): ?>
    <div class="about-circle">
      <div class="circle-wrap">
        <?php if (!empty($tjCircleImage['url'])): ?>
          <img class="rotate-image" src="<?php echo esc_url($tjCircleImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjCircleImage['id'], '_wp_attachment_image_alt', true)); ?>">
        <?php endif; ?>

        <?php if (!empty($tjCircleIconImage['url'])): ?>
          <span class="logo-icon">
            <img src="<?php echo esc_url($tjCircleIconImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tjCircleIconImage['id'], '_wp_attachment_image_alt', true)); ?>">
          </span>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>

  <?php if (!empty($tjImageTitle)): ?>
    <div class="establish-text"><?php echo tj_kses($tjImageTitle); ?></div>
  <?php endif; ?>

</div>