<?php
$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);


$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "";
// animation
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "sec-title text-anim";
} else {
  $titleClass = "sec-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);


$tjShowContent   = !empty($settings['is_content']) ? "yes" : "no";
$tjSectionContent   = $settings['tj_content'] ?? "";
// animation
$tjContentAnimation   = $settings['tj_content_animation'] ?? '';
$tjContentAnimationName   = $settings['tj_content_animation_name'] ?? '';
$tjContentAnimationDelay   = $settings['tj_content_animation_delay'] ?? '';
if (!empty($tjContentAnimation)) {
  $contentClass = "desc wow $tjContentAnimationName";
  $this->add_render_attribute('content_args', 'data-wow-delay', $tjContentAnimationDelay['size'] . "s");
} else {
  $contentClass = "desc";
}
$this->add_render_attribute('content_args', 'class', $contentClass);


// images
$tj_image = !empty($settings['tj_image']) ? $settings['tj_image'] : "";
$tj_shape_image = !empty($settings['tj_shape_image']) ? $settings['tj_shape_image'] : "";
$tj_star_show   = $settings['tj_star_show'] ?? '';

// animation
$tjimgAnimation   = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName   = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay   = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "about-bg-images wow $tjimgAnimationName";
  $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "about-bg-images";
}
$this->add_render_attribute('tj-image-arg', 'class', $imageClass);

// list
$lists = !empty($settings['tj_list']) ? $settings['tj_list'] : [];

// wrapper animation
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$wrapperClass = "about-feature-item";
if (!empty($tjButtonAnimation)) {
  $wrapperClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrapperClass);

// button
$tjButtonShow = !empty($settings['tj_button_show']) ? $settings['tj_button_show'] : 'no';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$this->add_render_attribute('tj_button_arg', 'class', 'tj-primary-btn');
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}

// counter
$tjCounterCount = (!empty($settings['tj_ff_number'])) ? $settings['tj_ff_number'] : "";
$tjCounterPrefix = (!empty($settings['tj_ff_prefix'])) ? $settings['tj_ff_prefix'] : "";
$tjCounterSuffix = (!empty($settings['tj_ff_suffix'])) ? $settings['tj_ff_suffix'] : "";
$tjCounterTitle = (!empty($settings['tj_ff_title'])) ? $settings['tj_ff_title'] : "";

$tj_cimage = !empty($settings['tj_cimage']) ? $settings['tj_cimage'] : "";
$tj_cimage2 = !empty($settings['tj_cimage2']) ? $settings['tj_cimage2'] : "";
$tj_cimage3 = !empty($settings['tj_cimage3']) ? $settings['tj_cimage3'] : "";

?>

<!-- start: About Section -->
<section class="tj-about-section">
  <div class="container">
    <div class="row">
      <div class="col-lg-6"></div>
      <div class="col-lg-6">
        <div class="about-left-content">
          <div class="sec-heading">
            <?php if (!empty($tjSectionSubtitle)) : ?>
              <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
                <?php echo esc_html($tjSectionSubtitle); ?>
              </span>
            <?php endif; ?>
            <?php
            if (!empty($tjSectionTitle)) :
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjSectionTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($tjSectionTitle)
              );
            endif;
            ?>
            <?php if ("yes" == $tjShowContent) : ?>
              <div <?php echo $this->get_render_attribute_string('content_args'); ?>>
                <?php echo tj_kses($tjSectionContent); ?>
              </div>
            <?php endif; ?>
          </div>
          <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
            <div class="feature-box">
              <div class="feature-left">
                <?php if (count($lists) > 0): ?>
                  <div class="check-list-one">
                    <ul>
                      <?php foreach ($lists as $item):
                        $icon = !empty($item['tj_item_icon']) ? $item['tj_item_icon'] : '';
                        $itemContent = !empty($item['tj_item_content']) ? $item['tj_item_content'] : '';
                      ?>
                        <li>
                          <?php if (!empty($icon['value'])) : ?>
                            <?php tj_render_icon($item, 'tj_icon', 'tj_item_icon') ?>
                          <?php endif; ?>

                          <?php echo esc_html__($itemContent, 'tjcore');  ?>
                        </li>
                      <?php endforeach; ?>
                    </ul>
                  </div>
                <?php endif; ?>

                <?php if ($tjButtonShow === 'yes'): ?>
                  <div class="about-button">
                    <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                      <span class="btn_inner">
                        <?php if (!empty($tjBtnIcon['value'])): ?>
                          <span class="btn_icon">
                            <span>
                              <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                              <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                            </span>
                          </span>
                        <?php endif; ?>
                        <?php if (!empty($tjBtnText)): ?>
                          <span class="btn_text">
                            <span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
                          </span>
                        <?php endif; ?>
                      </span>
                    </a>
                  </div>
                <?php endif; ?>
              </div>
            </div>
            <div class="feature-box">
              <div class="client-experience">
                <?php if (!empty($tj_cimage['url']) || !empty($tj_cimage2['url']) || !empty($tj_cimage3['url'])): ?>
                  <ul class="images-thumb">
                    <?php if (!empty($tj_cimage['url'])): ?>
                      <li>
                        <img src="<?php echo esc_url($tj_cimage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_cimage['id'], '_wp_attachment_image_alt', true)); ?>">
                      </li>
                    <?php endif; ?>
                    <?php if (!empty($tj_cimage2['url'])): ?>
                      <li>
                        <img src="<?php echo esc_url($tj_cimage2['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_cimage2['id'], '_wp_attachment_image_alt', true)); ?>">
                      </li>
                    <?php endif; ?>
                    <?php if (!empty($tj_cimage3['url'])): ?>
                      <li>
                        <img src="<?php echo esc_url($tj_cimage3['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_cimage3['id'], '_wp_attachment_image_alt', true)); ?>">
                      </li>
                    <?php endif; ?>
                    <li class="plus"><i class="fa-sharp fa-solid fa-plus"></i></li>
                  </ul>
                <?php endif; ?>
                <?php if (!empty($tjCounterCount)): ?>
                  <div class="funfact-item-one">
                    <div class="number">
                      <span><?php echo esc_html($tjCounterPrefix); ?></span>
                      <span class="odometer" data-count="<?php echo esc_html($tjCounterCount); ?>"></span>
                      <span><?php echo esc_html($tjCounterSuffix); ?></span>
                    </div>
                    <?php if (!empty($tjCounterTitle)): ?>
                      <span class="sub-title">
                        <?php echo tj_kses($tjCounterTitle, 'tjcore'); ?>
                      </span>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- shape images -->
  <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
    <?php if (!empty($tj_image['url'])): ?>
      <div class="about-shape-1 hover:shine">
        <img src="<?php echo esc_url($tj_image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_image['id'], '_wp_attachment_image_alt', true)); ?>">
      </div>
    <?php endif; ?>
    <?php if (!empty($tj_shape_image['url'])): ?>
      <div class="about-shape-2 hover:shine">
        <img src="<?php echo esc_url($tj_shape_image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($tj_shape_image['id'], '_wp_attachment_image_alt', true)); ?>">
      </div>
    <?php endif; ?>
    <?php if (!empty($tj_star_show)): ?>
      <div class="about-shape-3 zoominout">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/icons/star.svg" alt="Shapes">
      </div>
    <?php endif; ?>
  </div>
</section>
<!-- end: About Section -->